% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{GetTransferPredictions}
\alias{GetTransferPredictions}
\title{Get the predicted identity}
\usage{
GetTransferPredictions(
  object,
  assay = "predictions",
  slot = "data",
  score.filter = 0.75
)
}
\arguments{
\item{object}{Seurat object}

\item{assay}{Name of the assay holding the predictions}

\item{slot}{Slot of the assay in which the prediction scores are stored}

\item{score.filter}{Return "Unassigned" for any cell with a score less than
this value}
}
\value{
Returns a vector of predicted class names
}
\description{
Utility function to easily pull out the name of the class with the maximum
prediction. This is useful if you've set \code{prediction.assay = TRUE} in
\code{\link{TransferData}} and want to have a vector with the predicted class.
}
\examples{
\dontrun{
  prediction.assay <- TransferData(anchorset = anchors, refdata = reference$class)
  query[["predictions"]] <- prediction.assay
  query$predicted.id <- GetTransferPredictions(query)
}
}
