% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sketching.R
\name{SketchData}
\alias{SketchData}
\title{Sketch Data}
\usage{
SketchData(
  object,
  assay = NULL,
  ncells = 5000L,
  sketched.assay = "sketch",
  method = c("LeverageScore", "Uniform"),
  var.name = "leverage.score",
  over.write = FALSE,
  seed = 123L,
  cast = "dgCMatrix",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object.}

\item{assay}{Assay name. Default is NULL, in which case the default assay of the object is used.}

\item{ncells}{A positive integer indicating the number of cells to sample for the sketching. Default is 5000.}

\item{sketched.assay}{Sketched assay name. A  sketch assay is created or overwrite with the sketch data. Default is 'sketch'.}

\item{method}{Sketching method to use. Can be 'LeverageScore' or 'Uniform'.
Default is 'LeverageScore'.}

\item{var.name}{A metadata column name to store the leverage scores. Default is 'leverage.score'.}

\item{over.write}{whether to overwrite existing column in the metadata. Default is FALSE.}

\item{seed}{A positive integer for the seed of the random number generator. Default is 123.}

\item{cast}{The type to cast the resulting assay to. Default is 'dgCMatrix'.}

\item{verbose}{Print progress and diagnostic messages}

\item{...}{Arguments passed to other methods}
}
\value{
A Seurat object with the sketched data added as a new assay.
}
\description{
This function uses sketching methods to downsample high-dimensional single-cell RNA expression data,
which can help with scalability for large datasets.
}
\concept{sketching}
