% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{Assay-methods}
\alias{Assay-methods}
\alias{[.Assay}
\alias{[[.Assay}
\alias{dim.Assay}
\alias{dimnames.Assay}
\alias{merge.Assay}
\alias{subset.Assay}
\alias{[[<-,Assay-method}
\alias{colMeans,Assay-method}
\alias{colSums,Assay-method}
\alias{rowMeans,Assay-method}
\alias{rowSums,Assay-method}
\alias{show,Assay-method}
\title{\code{Assay} Methods}
\usage{
\method{[}{Assay}(x, i, j, ...)

\method{[[}{Assay}(x, i, ..., drop = FALSE)

\method{dim}{Assay}(x)

\method{dimnames}{Assay}(x)

\method{merge}{Assay}(x = NULL, y = NULL, add.cell.ids = NULL, merge.data = TRUE, ...)

\method{subset}{Assay}(x, cells = NULL, features = NULL, ...)

\S4method{[[}{Assay}(x, i, j, ...) <- value

\S4method{colMeans}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{colSums}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowMeans}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowSums}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{show}{Assay}(object)
}
\arguments{
\item{x, object}{An \code{\link{Assay}} object}

\item{i, features}{For \code{[[}: metadata names; for all other methods,
feature names or indices}

\item{j, cells}{Cell names or indices}

\item{...}{Arguments passed to other methods}

\item{drop}{See \code{\link[base]{drop}}}

\item{y}{A vector or list of one or more objects to merge}

\item{add.cell.ids}{A character vector of \code{length(x = c(x, y))};
appends the corresponding values to the start of each objects' cell names}

\item{merge.data}{Merge the data slots instead of just merging the counts
(which requires renormalization); this is recommended if the same
normalization approach was applied to all objects}

\item{value}{Additional metadata to add}

\item{na.rm}{logical.  Should missing values (including \code{NaN})
    be omitted from the calculations?}

\item{dims}{completely ignored by the \code{Matrix} methods.}

\item{slot}{Name of assay expression matrix to calculate column/row
means/sums on}
}
\value{
\code{[}: The \code{data} slot for features \code{i} and cells
\code{j}

\code{[[}: The feature-level metadata for \code{i}

\code{dim}: The number of features (\code{nrow}) and cells
(\code{ncol})

\code{dimnames}: Feature (row) and cell (column) names

\code{merge}: Merged object

\code{subset}: A subsetted \code{Assay}

\code{[[<-}: \code{x} with metadata \code{value} added as \code{i}

\code{colMeans}: The column (cell-wise) means of \code{slot}

\code{colSums}: The column (cell-wise) sums of \code{slot}

\code{rowMeans}: The row (feature-wise) means of \code{slot}

\code{rowSums}: The row (feature-wise) sums of \code{slot}

\code{show}: Prints summary to \code{\link[base]{stdout}} and
invisibly returns \code{NULL}
}
\description{
Methods for \code{\link{Assay}} objects for generics defined in
other packages
}
\section{Functions}{
\itemize{
\item \code{[.Assay}: Get expression data from an \code{Assay}

\item \code{[[.Assay}: Get feature-level metadata

\item \code{dim.Assay}: Number of cells and features for an \code{Assay}

\item \code{dimnames.Assay}: Cell- and feature-names for an \code{Assay}

\item \code{merge.Assay}: Merge \code{Assay} objects

\item \code{subset.Assay}: Subset an \code{Assay}

\item \code{[[<-,Assay-method}: Add feature-level metadata

\item \code{colMeans,Assay-method}: Calculate \code{\link[base]{colMeans}} on an
\code{Assay}

\item \code{colSums,Assay-method}: Calculate \code{\link[base]{colSums}} on an
\code{Assay}

\item \code{rowMeans,Assay-method}: Calculate \code{\link[base]{rowMeans}} on an
\code{Assay}

\item \code{rowSums,Assay-method}: Calculate \code{\link[base]{rowSums}} on an
\code{Assay}

\item \code{show,Assay-method}: Overview of an \code{Assay} object
}}

\concept{assay}
