% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{Segmentation-methods}
\alias{Segmentation-methods}
\alias{Cells.Segmentation}
\alias{GetTissueCoordinates.Segmentation}
\alias{RenameCells.Segmentation}
\alias{lengths.Segmentation}
\alias{subset.Segmentation}
\alias{[[<-,Segmentation,character,missing,ANY-method}
\alias{[[<-,Segmentation,character,missing,NULL-method}
\alias{[,Segmentation,ANY,ANY,ANY-method}
\alias{coordinates,Segmentation-method}
\alias{show,Segmentation-method}
\title{\code{Segmentation} Methods}
\usage{
\method{Cells}{Segmentation}(x, ...)

\method{GetTissueCoordinates}{Segmentation}(object, full = TRUE, ...)

\method{RenameCells}{Segmentation}(object, new.names = NULL, ...)

\method{lengths}{Segmentation}(x, use.names = TRUE)

\method{subset}{Segmentation}(x, cells = NULL, ...)

\S4method{[[}{Segmentation,character,missing,ANY}(x, i, j, ...) <- value

\S4method{[[}{Segmentation,character,missing,NULL}(x, i, j, ...) <- value

\S4method{[}{Segmentation,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{coordinates}{Segmentation}(obj, full = TRUE, ...)

\S4method{show}{Segmentation}(object)
}
\arguments{
\item{x, object, obj}{A
\code{\link[SeuratObject:Segmentation-class]{Segmentation}} object}

\item{...}{Arguments passed to other methods}

\item{full}{Expand the coordinates to the full polygon}

\item{new.names}{vector of new cell names}

\item{use.names}{Ignored}

\item{i, cells}{A vector of cells to keep; if \code{NULL}, defaults
to all cells}

\item{j, drop}{Ignored}

\item{value}{The value to assign to the slot specified by \code{i} in the \code{Segmentation} object.}
}
\value{
\code{Cells}: A vector of cell names

\code{GetTissueCoordinates}, \code{coordinates}: A data frame with
three columns:
\itemize{
 \item \dQuote{\code{x}}: the x-coordinate
 \item \dQuote{\code{y}}: the y-coordinate
 \item \dQuote{\code{cell}} or \dQuote{\code{ID}}: the cell name
}
If \code{full} is \code{TRUE}, then each coordinate will indicate a vertex
for the cell polygon; otherwise, each coordinate will indicate a centroid
for the cell. Note: \code{GetTissueCoordinates} ....

\code{RenameCells}: \code{object} with the cells renamed to
\code{new.names}

\code{lengths}: An \code{\link[base:rle]{rle}} object for the cells

\code{subset}, \code{[}: \code{x} subsetted to the cells specified
by \code{cells}/\code{i}

\code{[[<-}: 
\itemize{
 \item If \code{value} is an \code{sf} object,
 returns \code{x} with \code{value} stored in \code{sf};
 requires that \code{i} is \dQuote{sf.data}.
 \item If \code{value} is \code{NULL}, returns \code{x} with \code{sf} removed.
}

\code{show}: Invisibly returns \code{NULL}
}
\description{
Methods for \code{\link[SeuratObject:Segmentation-class]{Segmentation}}
objects
}
\details{
\code{Cells}: Get cell names

\code{GetTissueCoordinates}, \code{coordinates}: Get
tissue coordinates

\code{RenameCells}: Update cell names

\code{lengths}: Generate a run-length encoding of the cells present

\code{subset}, \code{[}: Subset a \code{Segmentation} object to
certain cells

\code{[[<-}: Attach or remove \code{sf} object to/from a \code{Segmentation} object

\code{show}: Display an object summary to stdout
}
\section{Progress Updates with \pkg{progressr}}{

The following methods use
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars:
\itemize{
 \item \code{RenameCells}
}
To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-intro.html}{\code{vignette("progressr-intro")}}
}

\section{Parallelization with \pkg{future}}{

The following methods use
\href{https://cran.r-project.org/package=future}{\pkg{future}} to enable
parallelization:
\itemize{
 \item \code{RenameCells}
}
Parallelization strategies can be set using
\code{\link[future]{plan}}. Common plans include \dQuote{\code{sequential}}
for non-parallelized processing or \dQuote{\code{multisession}} for parallel
evaluation using multiple \R sessions; for other plans, see the
\dQuote{Implemented evaluation strategies} section of
\code{\link[future:plan]{?future::plan}}. For a more thorough introduction
to \pkg{future}, see
\href{https://future.futureverse.org/articles/future-1-overview.html}{\code{vignette("future-1-overview")}}
}

\seealso{
\code{\link{Segmentation-class}}

Segmentation layer classes:
\code{\link{Centroids-class}},
\code{\link{Centroids-methods}},
\code{\link{Molecules-class}},
\code{\link{Molecules-methods}},
\code{\link{Segmentation-class}},
\code{\link{Segmentation-validity}}
}
\concept{future}
\concept{segmentation}
