% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAdjacent.R
\name{plotAdjacent}
\alias{plotAdjacent}
\title{Function for plotting category probabilities of adjacent logistic regression model}
\usage{
plotAdjacent(x, matching.name = "matching")
}
\arguments{
\item{x}{object of class \code{vglm}}

\item{matching.name}{character: name of matching criterion used for estimation in \code{x}.}
}
\description{
Function for plotting category probabilities function estimated by \code{vglm()} from \code{VGAM} package
}
\examples{
\dontrun{
# loading data
data <- dataMedicalgraded[, 1:100]

# total score calculation
score <- apply(data, 1, sum)
data[, 1] <- ordered(factor(data[, 1], levels = 0:max(data[, 1])))

# cummulative logistic model for item 1
fit <- vglm(data[, 1] ~ score, family = acat(reverse = FALSE, parallel = TRUE))
# coefficients for item 1
coefs <- coef(fit)

plotAdjacent(fit, matching.name = "Total score")
}
}
\seealso{
\code{\link[VGAM]{vglm}}
}
\author{
Tomas Jurica \cr
Faculty of Mathematics and Physics, Charles University \cr

Adela Hladka \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
hladka@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
