% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSim.R
\name{plottable.net}
\alias{plottable.net}
\title{Create a more Plotting-Friendly phylogenetic Network}
\usage{
plottable.net(net, tol = 1e-08)
}
\arguments{
\item{net}{An object of class \code{evonet}.}

\item{tol}{a tolerance to account for floating point imprecision. any values smaller than \code{tol} are considered to be zero.}
}
\value{
a network to be used with the \code{plot()} function
}
\description{
This function creates a more plotting-friendly \code{evonet} object to be used with the \code{plot()} function
}
\examples{
#' set.seed(17) ##smallest Quartan prime as seed
##Generate a tree with extinct leaves
net<-sim.bdh.age(1,1,5,2,1,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),complete=TRUE)[[1]]
plot(plottable.net(net))
}
