% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{FilterFragments}
\alias{FilterFragments}
\title{FilterFragments}
\usage{
FilterFragments(
  fragment.path,
  cells,
  output.path,
  assume.sorted = FALSE,
  compress = TRUE,
  index = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{fragment.path}{Path to a tabix-indexed fragments file}

\item{cells}{A vector of cells to retain}

\item{output.path}{Name and path for output tabix file. A tabix index file
will also be created in the same location, with the .tbi file extension.}

\item{assume.sorted}{Assume sorted input and don't sort the filtered file.
Can save a lot of time, but indexing will fail if assumption is wrong.}

\item{compress}{Compress filtered fragments using bgzip (default TRUE)}

\item{index}{Index the filtered tabix file (default TRUE)}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{\link[data.table]{fread}}}
}
\value{
None
}
\description{
Remove cells from a fragments file that are not present in a given list of
cells. Note that this reads the whole fragments file into memory, so may
require a lot of memory depending on the size of the fragments file.
}
\examples{
\donttest{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
output.path = file.path(tempdir(), "filtered.tsv")

FilterFragments(
  fragment.path = fpath,
  cells = colnames(atac_small),
  output.path = output.path
)
}
}
