% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifs.R
\name{FindMotifs}
\alias{FindMotifs}
\title{FindMotifs}
\usage{
FindMotifs(
  object,
  features,
  background = 40000,
  assay = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{features}{A vector of features to test for enrichments over background}

\item{background}{Either a vector of features to use as the background set,
or a number specify the number of features to randomly select as a background
set. If a number is provided, regions will be selected to match the sequence
characteristics of the query features. To match the sequence characteristics,
these characteristics must be stored in the feature metadata for the assay.
This can be added using the
 \code{\link{RegionStats}} function. If NULL, use all features in the assay.}

\item{assay}{Which assay to use. Default is the active assay}

\item{verbose}{Display messages}

\item{...}{Arguments passed to \code{\link{MatchRegionStats}}.}
}
\value{
Returns a data frame
}
\description{
Find motifs overrepresented in a given set of genomic features.
Computes the number of features containing the motif (observed) and
compares this to the total number of features containing the
motif (background) using the hypergeometric test.
}
\examples{
de.motif <- head(rownames(atac_small))
bg.peaks <- tail(rownames(atac_small))
FindMotifs(
object = atac_small,
features = de.motif,
background = bg.peaks
)
}
