% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{FractionCountsInRegion}
\alias{FractionCountsInRegion}
\title{Fraction of counts in a genomic region}
\usage{
FractionCountsInRegion(object, regions, assay = NULL, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{regions}{A GRanges object containing a set of genomic regions}

\item{assay}{Name of assay to use}

\item{...}{Additional arguments passed to \code{\link{CountsInRegion}}}
}
\value{
Returns a numeric vector
}
\description{
Find the fraction of counts per cell that overlap a given set of genomic
ranges
}
\examples{
FractionCountsInRegion(
  object = atac_small,
  assay = 'bins',
  regions = blacklist_hg19
)
}
\concept{utilities}
