% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewMVClaytonCopula.R
\name{NewMVClaytonCopula}
\alias{NewMVClaytonCopula}
\title{Creates a Clayton copula}
\usage{
NewMVClaytonCopula(theta = 1)
}
\arguments{
\item{theta}{real, the parameter of the Clayton copula, defaults to 1; must be positive.}
}
\value{
A function that evaluates the Clayton copula (with parameter \eqn{\alpha}{alpha}) at a given \eqn{d}-dimensional vector in the unit cube.  The environment of the function also contains a function called \code{pdfCopula} that evaluates the probability density function of the Clayton copula via automatic differentation.
}
\description{
Creates an instance of the Clayton copula with parameter \eqn{\theta}{theta}.
}
\details{
The following parameterisation of the copula is used:
\deqn{C(u_1,\dots,u_d) = \left(\left\{ \sum_{j=1}^d u_j^{-\theta} \right\} - (d-1) \right)^{-1/\theta}}{C(u_1,\dots,u_d) = ( { \sum_j u_j^{-theta} } - d + 1)^{-1/theta}}
}
\author{
Berwin A. Turlach <berwin.turlach@gmail.com>
}
\keyword{distribution}
