\name{rmult.crm}
\alias{rmult.crm}
\title{
Simulating Correlated Ordinal Responses Conditional on a Marginal Continuation-Ratio Model Specification
}
\description{
Simulates correlated ordinal responses assuming a continuation-ratio model for the marginal probabilities.
}
\usage{
rmult.crm(clsize, intercepts, betas, xformula, xdata, link, cor.matrix, rlatent = NULL)
}
\arguments{
  \item{clsize}{
integer indicating the common cluster size.
}
  \item{intercepts}{
numerical vector or matrix containing the intercepts of the marginal continuation-ratio model.
}
  \item{betas}{
numerical vector or matrix containing the value of the marginal regression parameter vector (excluding \code{intercepts}).
}
  \item{xformula}{
formula expression as in other marginal regression models but without including a response variable.  
}
  \item{xdata}{
optional data frame containing the variables provided in \code{xformula}.
}
  \item{link}{
character string indicating the link function of the marginal continuation-ratio model. Options include \code{"probit"}, \code{"logit"}, \code{"cloglog"} or \code{"cauchit"}. Required when \code{rlatent = NULL}.
}
  \item{cor.matrix}{
matrix indicating the correlation matrix of the multivariate normal distribution when the NORTA method is employed (\code{rlatent = NULL}).
}
 \item{rlatent}{
matrix with \code{clsize} rows and \code{ncategories} columns containing realizations of the latent random vectors when the NORTA method is not employed. See details for more info.
}
}
\details{
The assumed marginal continuation-ratio model is  
\deqn{Pr(Y_{it}=j |Y_{it} \ge j,x_{it})=F(\beta_{tj0} +\beta^{'}_{t} x_{it})}
where \eqn{F} is the cumulative distribution function determined by \code{link}. For subject \eqn{i}, \eqn{Y_{it}} is the \eqn{t}-th multinomial response and \eqn{x_{it}} is the associated covariates vector. Finally, \eqn{\beta_{tj0}} is the \eqn{j}-th category-specific intercept at the \eqn{t}-th measurement occasion and \eqn{\beta_{tj}} is the \eqn{j}-th category-specific regression parameter vector at the \eqn{t}-th measurement occasion.

The ordinal response \eqn{Y_{it}} is determined by extending the latent variable threshold approach of \cite{Tutz (1991)}. See vignette for more info.

When \eqn{\beta_{tj0}=\beta_{j0}} for all \eqn{t}, then \code{intercepts} should be provided as a numerical vector. Otherwise, \code{intercepts} must be a numerical matrix such that row \eqn{t} contains the category-specific intercepts at the \eqn{t}-th measurement occasion.

\code{betas} should be provided as a numeric vector only when \eqn{\beta_{t}=\beta} for all \eqn{t}. Otherwise, \code{betas} must be provided as a numeric matrix with \code{clsize} rows such that the \eqn{t}-th row contains the value of \eqn{\beta_{t}}. In either case, \code{betas} should reflect the order of the terms implied by \code{xformula}.

The appropriate use of \code{xformula} is \code{xformula = ~ covariates}, where \code{covariates} indicate the linear predictor as in other marginal regression models.

The optional argument \code{xdata} should be provided in ``long'' format.

The NORTA method is the default option for simulating the latent random vectors denoted by \eqn{e_{itj}} in the threshold approach described in the vignette. In this case, the algorithm forces \code{cor.matrix} to respect the local independence assumption. To import simulated values for the latent random vectors without utilizing the NORTA method, the user can employ the \code{rlatent} argument. In this case, row \eqn{i} corresponds to subject \eqn{i} and columns \eqn{(t-1)*\code{ncategories}+1,...,t*\code{ncategories}} should contain the realization of \eqn{e_{it1},...,e_{itJ}}, respectively, for \eqn{t=1,\ldots,\code{clsize}}.
}
\value{
Returns a list that has components:
\item{Ysim}{the simulated ordinal responses. Element (\eqn{i},\eqn{t}) represents the realization of \eqn{Y_{it}}.}
\item{simdata}{a data frame that includes the simulated response variables (y), the covariates specified by \code{xformula}, subjects' identities (id) and the corresponding measurement occasions (time).}
\item{rlatent}{the latent random variables denoted by \eqn{e_{it}} in the vignette.}
}
\references{
Cario, M. C. and Nelson, B. L. (1997)  \emph{Modeling and generating random vectors with arbitrary marginal distributions and correlation matrix}. Technical Report, Department of Industrial Engineering and Management Sciences, Northwestern University, Evanston, Illinois.

Li, S. T. and Hammond, J. L. (1975)  Generation of pseudorandom numbers with specified univariate distributions and correlation coefficients. \emph{IEEE Transactions on Systems, Man and Cybernetics} \bold{5}, 557--561.

Tutz, G. (1991) Sequential models in categorical regression. \emph{Computational Statistics & Data Analysis} \bold{11}, 275--295.
}
\author{
Anestis Touloumis
}
\seealso{
\code{\link{rmult.bcl}} for simulating correlated nominal responses, \code{\link{rmult.clm}} for simulating correlated ordinal responses and \code{\link{rbin}} for simulating correlated binary responses. 
}
\examples{
## See vignette for more details about the sampling scheme.
set.seed(1)
N <- 500
clsize <- 4
intercepts <- c(-1.5, -0.5, 0.5, 1.5)
cor.matrix <- diag(1, 16)
x <- rnorm(N * clsize)
CorOrdRes <- rmult.crm(clsize = clsize, intercepts = intercepts, betas = 1, 
    xformula = ~x, cor.matrix = cor.matrix, link = "probit")
    }

