% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RE}
\alias{RE}
\title{Compute the relative efficiency of multiple estimators}
\usage{
RE(x, MSE = FALSE)
}
\arguments{
\item{x}{a \code{numeric} vector of root mean square error values (see \code{\link{RMSE}}),
where the first element will be used as the reference. Otherwise, the object could contain
MSE values if the flag \code{MSE = TRUE} is also included}

\item{MSE}{logical; are the input value mean squared errors instead of root mean square errors?}
}
\value{
returns a \code{vector} of variance ratios indicating the relative efficiency compared
  to the first estimator. Values less than 1 indicate better efficiency, while
  values greater than 1 indicate worse efficiency
}
\description{
Computes the relative efficiency given the RMSE (default) or MSE values for multiple estimators.
}
\examples{

pop <- 1
samp1 <- rnorm(100, 1, sd = 0.5)
RMSE1 <- RMSE(samp1, pop)
samp2 <- rnorm(100, 1, sd = 1)
RMSE2 <- RMSE(samp2, pop)

RE(c(RMSE1, RMSE2))

# using MSE instead
mse <- c(RMSE1, RMSE2)^2
RE(mse, MSE = TRUE)

}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\url{http://www.tandfonline.com/doi/full/10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
