% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgenerate.R
\name{rmvt}
\alias{rmvt}
\title{Generate data with the multivariate t distribution}
\usage{
rmvt(n, sigma, df, delta = rep(0, nrow(sigma)), Kshirsagar = FALSE)
}
\arguments{
\item{n}{number of observations to generate}

\item{sigma}{positive definite covariance matrix}

\item{df}{degrees of freedom. \code{df = 0} and \code{df = Inf}
corresponds to the multivariate normal distribution}

\item{delta}{the vector of non-centrality parameters of length \code{n}
which specifies the either the modes (default) or non-centrality parameters}

\item{Kshirsagar}{logical; triggers whether to generate data with non-centrality parameters
or to adjust the simulated data to the mode of the distribution. The default uses the mode}
}
\value{
a numeric matrix with columns equal to \code{ncol(sigma)}
}
\description{
Function generates data from the multivariate t distribution given a covariance matrix,
non-centrality parameter (or mode), and degrees of freedom.
}
\examples{

# random t values given variances [3,6], covariance 2, and df = 15
sigma <- matrix(c(3,2,2,6), 2, 2)
x <- rmvt(1000, sigma = sigma, df = 15)
head(x)
summary(x)
plot(x[,1], x[,2])


}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{runSimulation}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
