% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notifications.R
\name{new_PushbulletNotifier}
\alias{new_PushbulletNotifier}
\title{Create a Pushbullet Notifier}
\usage{
new_PushbulletNotifier(
  config_path = "~/.rpushbullet.json",
  verbose_issues = FALSE
)
}
\arguments{
\item{config_path}{A character string specifying the path to the Pushbullet configuration file.
Defaults to \code{"~/.rpushbullet.json"}.}

\item{verbose_issues}{Logical. If \code{TRUE}, includes detailed information about warnings
and errors in notifications. Default is \code{FALSE}.}
}
\value{
An S3 object of class \code{"PushbulletNotifier"} and \code{"Notifier"}.
}
\description{
Constructs a notifier object for sending messages via Pushbullet. This requires a
Pushbullet account, the Pushbullet application installed on both a mobile device
and computer, and a properly configured JSON file (typically \code{~/.rpushbullet.json},
using \code{RPushbullet::pbSetup()}).
}
\details{
To use \code{RPushbullet} in \code{SimDesign}, create a \code{PushbulletNotifier}
object using \code{new_PushbulletNotifier()} and pass it to the \code{notifier}
argument in \code{runSimulation()}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a Pushbullet notifier (requires a valid configuration file)
pushbullet_notifier <- new_PushbulletNotifier(verbose_issues = TRUE)
\dontshow{\}) # examplesIf}
}
