% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activities.R
\name{activities}
\alias{activities}
\title{Activity computation}
\usage{
activities(kin_fun,Keq_fun)
}
\arguments{
\item{kin_fun}{Numeric vector of kinetic parameters (catalytic constant kcat divided by Michaelis constant Km)}

\item{Keq_fun}{Numeric vector of equilibrium constants}
}
\value{
Numeric vector of activities of each enzyme, of same length as \code{kin_fun} and \code{Keq_fun}.
}
\description{
Computes the enzyme pseudo-activities
}
\details{
Computes the pseudo-activities of enzymes,
    i.e. for each enzyme, the product of its kcat/Km (kinetic parameters)
    by the product of the upstream reactions equilibrium constants.
    
In other functions, pseudo-activity is also named activity.

\code{kin_fun} and \code{Keq_fun} need to have the same length.
}
\examples{
#Values from CoA metabolism
kin <- c(53/0.29,50/0.78,29,6.22) #kinetic parameters kcat/Km
Keq <- c(1.1e+8,4.9e+3,1.1e+3,0.228) #equilibrium constants
A <- activities(kin,Keq) #activities

# results : A = c(1.827586e+02, 7.051282e+09, 1.563100e+13, 3.687838e+15)

}
\references{
Lion, S., F. Gabriel, B. Bost, J. Fiévet, C. Dillmann, and D. De Vienne, 2004. 
An extension to the metabolic control theory taking into account correlations between enzyme concentrations.
European Journal of Biochemistry 271:4375–4391.
}
