% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_group.R
\name{search_group}
\alias{search_group}
\title{Search the regulation group for an enzyme}
\usage{
search_group(i,Lv)
}
\arguments{
\item{i}{Integer which is the number of the interest enzyme}

\item{Lv}{List of regulation group, preferably the output of function \code{\link{class_group}}}
}
\value{
Return an integer which is the number \eqn{q} of the group \eqn{Phi_q} that contains the interest enzyme
}
\description{
Give the number of the regulation group \eqn{Phi_q} where is the interest enzyme giving the list of regulation group
}
\details{
Enzymes are classified in regulation groups depending on the co-regulation matrix (see function \code{link{class_group}}).

Function \code{search_group} also allows to find the group type from the list of group types.
In that case, \code{i} is the interest group, and \code{Lv} is the list of group type, which the output of function \code{\link{group_types}}.

More largely, the function gives the number of a list element that contains a particular number.
}
\examples{

## One group
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
L_Phi <- class_group(beta)

#enzyme 2 is in group 1
search_group(2,L_Phi)

## Two groups
n <- 3
beta <- diag(1,n) 
beta[1,2] <- -0.32 
beta[2,1] <- 1/beta[1,2]

L_Phi <- class_group(beta)

search_group(2,L_Phi) #gives 1 
search_group(3,L_Phi) #gives 2

}
\seealso{
Function \code{\link{class_group}} to compute the list of regulation groups
}
