% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduled_events.R
\name{scheduled_events}
\alias{scheduled_events}
\title{Create S4 class \code{scheduled_events}}
\usage{
scheduled_events(E = NULL, N = NULL, events = NULL)
}
\arguments{
\item{E}{Sparse matrix of object class \code{"\linkS4class{dgCMatrix}"}
that selects the states to include for sampling in an event.}

\item{N}{Sparse matrix of object class \code{"\linkS4class{dgCMatrix}"}
that determines how to shift the states in an
\code{INTERNAL_TRANSFER_EVENT}.}

\item{events}{A \code{data.frame} with events.}
}
\value{
S4 class \code{scheduled_events}
}
\description{
The argument events must be a \code{data.frame} with the following
columns:
\itemize{
  \item{event}{
    The event type. The following four type of events exists;
    \code{EXIT_EVENT = 0}, \code{ENTER_EVENT = 1},
    \code{INTERNAL_TRANSFER_EVENT = 2}, and
    \code{EXTERNAL_TRANSFER_EVENT = 3}.
  }
  \item{time}{
    The time of the event.
  }
  \item{node}{
    The node of the event
  }
  \item{dest}{
    The destination node for an \code{EXTERNAL_TRANSFER_EVENT}.
  }
  \item{n}{
    The number of individuals in the event. n[i] >= 0.
  }
  \item{proportion}{
    If n[i] equals zero, then the number of individuals to sample
    is calculated by summing the number of individuals in the
    states determined by select[i] and multiplying with the
    proportion. 0 <= proportion[i] <= 1.
  }
  \item{select}{
    Column \code{j} in the event matrix \code{E} that determines
    the states to sample from.
  }
  \item{shift}{
    The column \code{shift[i]} in the \code{N} matrix determines
    how to change state of a sampled individual in an
    \code{INTERNAL_TRANSFER_EVENT}. Should be \code{-1} for the
    other event types.
  }
}
}

