% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{trajectory}
\alias{trajectory}
\title{Generic function to extract data from a simulated trajectory}
\usage{
trajectory(model, compartments = NULL, index = NULL, ...)
}
\arguments{
\item{model}{the object to extract the trajectory from.}

\item{compartments}{specify the names of the compartments to
extract data from. The compartments can be specified as a
character vector e.g. \code{compartments = c('S', 'I', 'R')},
or as a formula e.g. \code{compartments = ~S+I+R} (see
\sQuote{Examples}). Default (\code{compartments=NULL}) is to
extract the number of individuals in each compartment i.e. the
data from all discrete state compartments in the model. In
models that also have continuous state variables e.g. the
\code{SISe} model, they are also included.}

\item{index}{indices specifying the subset of nodes to include
when extracting data. Default (\code{index = NULL}) is to
extract data from all nodes.}

\item{...}{Additional arguments, see
\code{\link{trajectory,SimInf_model-method}}}
}
\description{
Generic function to extract data from a simulated trajectory
}
