% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/u0.R
\name{u0}
\alias{u0}
\alias{u0,SimInf_model-method}
\alias{u0,SimInf_indiv_events-method}
\title{Get the initial compartment state}
\usage{
u0(object, ...)

\S4method{u0}{SimInf_model}(object, ...)

\S4method{u0}{SimInf_indiv_events}(object, time = NULL, target = NULL, age = NULL)
}
\arguments{
\item{object}{The object to get the initial compartment state
\code{u0} from.}

\item{...}{Additional arguments.}

\item{time}{Only used when object is of class
\code{SimInf_indiv_events} object. The time-point that will be
used to create u0. If left empty (the default), the earliest
time among the events will be used.}

\item{target}{Only used when object is of class
\code{SimInf_indiv_events} object. The SimInf model ('SEIR',
'SIR', 'SIS', 'SISe3', 'SISe3_sp', 'SISe', or 'SISe_sp') to
target the events and u0 for. The default, \code{NULL},
creates an \code{u0}, but where the compartments might have to
be renamed and post-processed to fit the specific use case.}

\item{age}{Only used when object is of class
\code{SimInf_indiv_events} object. An integer vector with
break points in days for the ageing events. The default,
\code{NULL}, creates an \code{u0} where all individuals belong
to the same age category.}
}
\value{
a \code{data.frame} with the initial compartment state.
}
\description{
Get the initial compartment state
}
\examples{
## Create an SIR model object.
model <- SIR(u0 = data.frame(S = 99, I = 1, R = 0),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Get the initial compartment state.
u0(model)
}
