% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_final_corr.R
\name{calc_final_corr}
\alias{calc_final_corr}
\title{Calculate Final Correlation Matrix}
\usage{
calc_final_corr(k_cat, k_cont, k_pois, k_nb, Y_cat, Yb, Y_pois, Y_nb)
}
\arguments{
\item{k_cat}{the number of ordinal (r >= 2 categories) variables}

\item{k_cont}{the number of continuous variables}

\item{k_pois}{the number of Poisson variables}

\item{k_nb}{the number of Negative Binomial variables}

\item{Y_cat}{the ordinal (r >= 2 categories) variables}

\item{Yb}{the continuous variables}

\item{Y_pois}{the Poisson variables}

\item{Y_nb}{the Negative Binomial variables}
}
\value{
a correlation matrix
}
\description{
This function calculates the final correlation matrix based on simulated variable type (ordinal, continuous, Poisson, and/or
    Negative Binomial).  The function is used in \code{\link[SimMultiCorrData]{rcorrvar}} and
    \code{\link[SimMultiCorrData]{rcorrvar2}}.  This would not ordinarily be called directly by the user.
}
\seealso{
\code{\link[SimMultiCorrData]{rcorrvar}}, \code{\link[SimMultiCorrData]{rcorrvar2}}
}
