% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_cdf_prob.R
\name{sim_cdf_prob}
\alias{sim_cdf_prob}
\title{Calculate Simulated (Empirical) Cumulative Probability}
\usage{
sim_cdf_prob(sim_y, delta = 0.5)
}
\arguments{
\item{sim_y}{a vector of simulated data}

\item{delta}{the value y at which to evaluate the cumulative probability}
}
\value{
A list with components:

\code{cumulative_prob} the empirical cumulative probability up to delta

\code{Fn} the empirical distribution function
}
\description{
This function calculates a cumulative probability using simulated data and
    Martin Maechler's \code{\link[stats]{ecdf}} function.  \eqn{Fn} is a step function with jumps \eqn{i/n} at observation
    values, where \eqn{i} is the number of tied observations at that value. Missing values are ignored. For
    observations \eqn{y = (y1, y2, ..., yn)}, \eqn{Fn} is the fraction of observations less or equal to \eqn{t}, i.e.,
    \eqn{Fn(t) = sum[yi <= t]/n}.  This works for continuous, ordinal, or count variables.
}
\examples{
# Beta(a = 4, b = 2) Distribution:
x <- rbeta(10000, 4, 2)
sim_cdf_prob(x, delta = 0.5)

}
\seealso{
\code{\link[stats]{ecdf}}, \code{\link[SimMultiCorrData]{plot_sim_cdf}}
}
\keyword{cumulative,}
\keyword{empirical,}
\keyword{probability}
\keyword{simulated,}
\keyword{statistics,}
