% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PedSim_Functions.R
\name{create_founder}
\alias{create_founder}
\title{Create a new seed founder}
\usage{
create_founder(FamID, GRR, carrier_prob, RVfounder, founder_byears)
}
\arguments{
\item{FamID}{Numeric. The family ID to assign to the simulated pedigree.}

\item{GRR}{Numeric. The genetic relative-risk of disease, i.e. the relative-risk of disease for individuals who carry at least one copy of the causal variant.}

\item{carrier_prob}{Numeric.  The carrier probability for all causal variants with relative-risk of disease \code{GRR}.  By default, \code{carrier_prob}\code{ = 0.002}}

\item{RVfounder}{Logical.  Indicates if all pedigrees segregate the rare, causal variant.  By default, \code{RVfounder = FALSE} See details.}

\item{founder_byears}{Numeric vector of length 2.  The span of years from which to simulate, uniformly, the birth year for the founder who introduced the rare variant to the pedigree.}
}
\value{
\code{new_founder_info} the pedigree information for the new mate.
}
\description{
Create new seed founder for pedigree.
}
\keyword{internal}
