% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_sys.R
\name{summary_sys}
\alias{summary_sys}
\title{Summary of Correlated Systems of Variables}
\usage{
summary_sys(Y = NULL, E = NULL, E_mix = NULL, X = list(),
  X_all = list(), M = NULL, method = c("Fleishman", "Polynomial"),
  means = list(), vars = list(), skews = list(), skurts = list(),
  fifths = list(), sixths = list(), mix_pis = list(), mix_mus = list(),
  mix_sigmas = list(), mix_skews = list(), mix_skurts = list(),
  mix_fifths = list(), mix_sixths = list(), marginal = list(),
  support = list(), lam = list(), p_zip = list(), size = list(),
  prob = list(), mu = list(), p_zinb = list(), corr.x = list(),
  corr.e = NULL, U = list(), U_all = list(), rand.int = c("none",
  "non_mix", "mix"), rand.tsl = c("none", "non_mix", "mix"),
  corr.u = list(), rmeans2 = list(), rvars2 = list())
}
\arguments{
\item{Y}{the matrix of outcomes simulated with \code{corrsys} or \code{corrsys2}}

\item{E}{the matrix of continuous non-mixture or components of mixture error terms}

\item{E_mix}{the matrix of continuous mixture error terms}

\item{X}{a list of length \code{M} where \code{X[[p]] = cbind(X_cat(pj), X_cont(pj), X_comp(pj), X_pois(pj), X_nb(pj))}; keep
\code{X[[p]] = NULL} if \eqn{Y_p} has no independent variables}

\item{X_all}{a list of length \code{M} where \code{X_all[[p]]} contains all independent variables, interactions, and time for \eqn{Y_p}; keep
\code{X_all[[p]] = NULL} if \eqn{Y_p} has no independent variables}

\item{M}{the number of dependent variables \eqn{Y} (outcomes); equivalently, the number of equations in the system}

\item{method}{the PMT method used to generate all continuous variables, including independent variables (covariates), error terms, and random effects;
"Fleishman" uses Fleishman's third-order polynomial transformation and "Polynomial" uses Headrick's fifth-order transformation}

\item{means}{if no random effects, a list of length \code{M} where \code{means[[p]]} contains a vector of means for the continuous independent variables
    in equation p with non-mixture (\eqn{X_{cont}}) or mixture (\eqn{X_{mix}}) distributions and for the error terms (\eqn{E});
    order in vector is \eqn{X_{cont}, X_{mix}, E}

    if there are random effects, a list of length \code{M + 1} if the effects are the same across equations or \code{2 * M} if they differ;
    where \code{means[M + 1]} or \code{means[(M + 1):(2 * M)]} are vectors of means for all random effects with continuous non-mixture or mixture distributions;
    order in vector is 1st random intercept \eqn{U_0} (if \code{rand.int != "none"}), 2nd random time slope \eqn{U_1} (if \code{rand.tsl != "none"}),
    3rd other random slopes with non-mixture distributions \eqn{U_{cont}}, 4th other random slopes with mixture distributions \eqn{U_{mix}}}

\item{vars}{a list of same length and order as \code{means} containing vectors of variances for the continuous variables, error terms, and any random effects}

\item{skews}{if no random effects, a list of length \code{M} where \code{skews[[p]]} contains a vector of skew values for the continuous independent variables
    in equation p with non-mixture (\eqn{X_{cont}}) distributions and for \eqn{E} if \code{error_type = "non_mix"}; order in vector is \eqn{X_{cont}, E}

    if there are random effects, a list of length \code{M + 1} if the effects are the same across equations or \code{2 * M} if they differ;
    where \code{skews[M + 1]} or \code{skews[(M + 1):(2 * M)]} are vectors of skew values for all random effects with continuous non-mixture distributions;
    order in vector is 1st random intercept \eqn{U_0} (if \code{rand.int = "non_mix"}), 2nd random time slope \eqn{U_1} (if \code{rand.tsl = "non_mix"}),
    3rd other random slopes with non-mixture distributions \eqn{U_{cont}}}

\item{skurts}{a list of same length and order as \code{skews} containing vectors of standardized kurtoses (kurtosis - 3) for the continuous variables,
error terms, and any random effects with non-mixture distributions}

\item{fifths}{a list of same length and order as \code{skews} containing vectors of standardized fifth cumulants for the continuous variables,
error terms, and any random effects with non-mixture distributions; not necessary for \code{method = "Fleishman"}}

\item{sixths}{a list of same length and order as \code{skews} containing vectors of standardized sixth cumulants for the continuous variables,
error terms, and any random effects with non-mixture distributions; not necessary for \code{method = "Fleishman"}}

\item{mix_pis}{list of length \code{M}, \code{M + 1} or \code{2 * M}, where \code{mix_pis[1:M]} are for \eqn{X_{cont}, E} (if \code{error_type = "mix"}) and
    \code{mix_pis[M + 1]} or \code{mix_pis[(M + 1):(2 * M)]} are for mixture \eqn{U}; use \code{mix_pis[[p]] = NULL} if equation p has no continuous mixture terms
    if \code{error_type = "non_mix"} and there are only random effects (i.e., \code{length(corr.x) = 0}), use \code{mix_pis[1:M] = NULL} so that
    \code{mix_pis[M + 1]} or \code{mix_pis[(M + 1):(2 * M)]} describes the mixture \eqn{U};

    \code{mix_pis[[p]][[j]]} is a vector of mixing probabilities of the component distributions for \eqn{X_{mix(pj)}}, the j-th mixture covariate for outcome \eqn{Y_p};
    the last vector in \code{mix_pis[[p]]} is for \eqn{E_p} (if \code{error_type = "mix"}); components should be ordered as in \code{corr.x}

    \code{mix_pis[[M + p]][[j]]} is a vector of mixing probabilities of the component distributions for \eqn{U_{(pj)}}, the j-th random effect with a mixture distribution
    for outcome \eqn{Y_p}; order is 1st random intercept (if \code{rand.int = "mix"}), 2nd random time slope (if \code{rand.tsl = "mix"}),
    3rd other random slopes with mixture distributions; components should be ordered as in \code{corr.u}}

\item{mix_mus}{list of same length and order as \code{mix_pis};

    \code{mix_mus[[p]][[j]]} is a vector of means of the component distributions for \eqn{X_{mix(pj)}},
    the last vector in \code{mix_mus[[p]]} is for \eqn{E_p} (if \code{error_type = "mix"})

    \code{mix_mus[[p]][[j]]} is a vector of means of the component distributions for \eqn{U_{mix(pj)}}}

\item{mix_sigmas}{list of same length and order as \code{mix_pis};

    \code{mix_sigmas[[p]][[j]]} is a vector of standard deviations of the component distributions for \eqn{X_{mix(pj)}},
    the last vector in \code{mix_sigmas[[p]]} is for \eqn{E_p} (if \code{error_type = "mix"})

    \code{mix_sigmas[[p]][[j]]} is a vector of standard deviations of the component distributions for \eqn{U_{mix(pj)}}}

\item{mix_skews}{list of same length and order as \code{mix_pis};

    \code{mix_skews[[p]][[j]]} is a vector of skew values of the component distributions for \eqn{X_{mix(pj)}},
    the last vector in \code{mix_skews[[p]]} is for \eqn{E_p} (if \code{error_type = "mix"})

    \code{mix_skews[[p]][[j]]} is a vector of skew values of the component distributions for \eqn{U_{mix(pj)}}}

\item{mix_skurts}{list of same length and order as \code{mix_pis};

    \code{mix_skurts[[p]][[j]]} is a vector of standardized kurtoses of the component distributions for \eqn{X_{mix(pj)}},
    the last vector in \code{mix_skurts[[p]]} is for \eqn{E_p} (if \code{error_type = "mix"})

    \code{mix_skurts[[p]][[j]]} is a vector of standardized kurtoses of the component distributions for \eqn{U_{mix(pj)}}}

\item{mix_fifths}{list of same length and order as \code{mix_pis}; not necessary for \code{method = "Fleishman"};

    \code{mix_fifths[[p]][[j]]} is a vector of standardized fifth cumulants of the component distributions for \eqn{X_{mix(pj)}},
    the last vector in \code{mix_fifths[[p]]} is for \eqn{E_p} (if \code{error_type = "mix"})

    \code{mix_fifths[[p]][[j]]} is a vector of standardized fifth cumulants of the component distributions for \eqn{U_{mix(pj)}}}

\item{mix_sixths}{list of same length and order as \code{mix_pis}; not necessary for \code{method = "Fleishman"};

    \code{mix_sixths[[p]][[j]]} is a vector of standardized sixth cumulants of the component distributions for \eqn{X_{mix(pj)}},
    the last vector in \code{mix_sixths[[p]]} is for \eqn{E_p} (if \code{error_type = "mix"})

    \code{mix_sixths[[p]][[j]]} is a vector of standardized sixth cumulants of the component distributions for \eqn{U_{mix(pj)}}}

\item{marginal}{a list of length \code{M}, with the p-th component a list of cumulative probabilities for the ordinal variables
associated with outcome \eqn{Y_p} (use \code{marginal[[p]] = NULL} if outcome \eqn{Y_p} has no ordinal variables);
\code{marginal[[p]][[j]]} is a vector of the cumulative probabilities defining the marginal distribution of \eqn{X_{ord(pj)}},
the j-th ordinal variable for outcome \eqn{Y_p}; if the variable can take r values, the vector will contain r - 1 probabilities
(the r-th is assumed to be 1); for binary variables, the probability is the probability of the 1st category, which has the smaller support value;
\code{length(marginal[[p]])} can differ across outcomes; the order should be the same as in \code{corr.x}}

\item{support}{a list of length \code{M}, with the p-th component a list of support values for the ordinal variables associated
with outcome \eqn{Y_p}; use \code{support[[p]] = NULL} if outcome \eqn{Y_p} has no ordinal variables;
\code{support[[p]][[j]]} is a vector of the support values defining the marginal distribution of \eqn{X_{ord(pj)}},
the j-th ordinal variable for outcome \eqn{Y_p}; if not provided, the default for r categories is 1, ..., r}

\item{lam}{list of length \code{M}, p-th component a vector of lambda (means > 0) values for Poisson variables for outcome \eqn{Y_p}
(see \code{stats::dpois}); order is 1st regular Poisson and 2nd zero-inflated Poisson; use \code{lam[[p]] = NULL} if outcome \eqn{Y_p} has no Poisson variables;
\code{length(lam[[p]])} can differ across outcomes; the order should be the same as in \code{corr.x}}

\item{p_zip}{a list of vectors of probabilities of structural zeros (not including zeros from the Poisson distribution) for the
zero-inflated Poisson variables (see \code{VGAM::dzipois}); if \code{p_zip} = 0, \eqn{Y_{pois}} has a regular Poisson
distribution; if \code{p_zip} is in (0, 1), \eqn{Y_{pois}} has a zero-inflated Poisson distribution;
if \code{p_zip} is in \code{(-(exp(lam) - 1)^(-1), 0)}, \eqn{Y_{pois}} has a zero-deflated Poisson distribution and \code{p_zip}
is not a probability; if \code{p_zip = -(exp(lam) - 1)^(-1)}, \eqn{Y_{pois}} has a positive-Poisson distribution
(see \code{VGAM::dpospois}); order is 1st regular Poisson and 2nd zero-inflated Poisson;
if a single number, all Poisson variables given this value; if a vector of length \code{M}, all Poisson variables in equation p
given \code{p_zip[p]}; otherwise, missing values are set to 0 and ordered 1st}

\item{size}{list of length \code{M}, p-th component a vector of size parameters for the Negative Binomial variables for outcome \eqn{Y_p}
(see \code{stats::nbinom}); order is 1st regular NB and 2nd zero-inflated NB; use \code{size[[p]] = NULL} if outcome \eqn{Y_p} has no Negative Binomial variables;
\code{length(size[[p]])} can differ across outcomes; the order should be the same as in \code{corr.x}}

\item{prob}{list of length \code{M}, p-th component a vector of success probabilities for the Negative Binomial variables for outcome \eqn{Y_p}
(see \code{stats::nbinom}); order is 1st regular NB and 2nd zero-inflated NB; use \code{prob[[p]] = NULL} if outcome \eqn{Y_p} has no Negative Binomial variables;
\code{length(prob[[p]])} can differ across outcomes; the order should be the same as in \code{corr.x}}

\item{mu}{list of length \code{M}, p-th component a vector of mean values for the Negative Binomial variables for outcome \eqn{Y_p}
(see \code{stats::nbinom}); order is 1st regular NB and 2nd zero-inflated NB; use \code{mu[[p]] = NULL} if outcome \eqn{Y_p} has no Negative Binomial variables;
\code{length(mu[[p]])} can differ across outcomes; the order should be the same as in \code{corr.x}; for zero-inflated NB variables,
this refers to the mean of the NB distribution (see \code{VGAM::dzinegbin})
(*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables, not a mixture)}

\item{p_zinb}{a vector of probabilities of structural zeros (not including zeros from the NB distribution) for the zero-inflated NB variables
(see \code{VGAM::dzinegbin}); if \code{p_zinb} = 0, \eqn{Y_{nb}} has a regular NB distribution;
if \code{p_zinb} is in \code{(-prob^size/(1 - prob^size),} \code{0)}, \eqn{Y_{nb}} has a zero-deflated NB distribution and \code{p_zinb}
is not a probability; if \code{p_zinb = -prob^size/(1 - prob^size)}, \eqn{Y_{nb}} has a positive-NB distribution (see
\code{VGAM::dposnegbin}); order is 1st regular NB and 2nd zero-inflated NB;
if a single number, all NB variables given this value; if a vector of length \code{M}, all NB variables in equation p
given \code{p_zinb[p]}; otherwise, missing values are set to 0 and ordered 1st}

\item{corr.x}{list of length \code{M}, each component a list of length \code{M}; \code{corr.x[[p]][[q]]} is matrix of correlations
for independent variables in equations p (\eqn{X_{(pj)}} for outcome \eqn{Y_p}) and q (\eqn{X_{(qj)}} for outcome \eqn{Y_q});
order: 1st ordinal (same order as in \code{marginal}), 2nd continuous non-mixture (same order as in \code{skews}),
3rd components of continuous mixture (same order as in \code{mix_pis}), 4th regular Poisson, 5th zero-inflated Poisson (same order as in \code{lam}),
6th regular NB, and 7th zero-inflated NB (same order as in \code{size});
if p = q, \code{corr.x[[p]][[q]]} is a correlation matrix with \code{nrow(corr.x[[p]][[q]])} = # \eqn{X_{(pj)}} for outcome \eqn{Y_p};
if p != q, \code{corr.x[[p]][[q]]} is a non-symmetric matrix of correlations where rows correspond to covariates for \eqn{Y_p}
so that \code{nrow(corr.x[[p]][[q]])} = # \eqn{X_{(pj)}} for outcome \eqn{Y_p} and
columns correspond to covariates for \eqn{Y_q} so that \code{ncol(corr.x[[p]][[q]])} = # \eqn{X_{(qj)}} for outcome \eqn{Y_q};
use \code{corr.x[[p]][[q]] = NULL} if equation q has no \eqn{X_{(qj)}}; use \code{corr.x[[p]] = NULL} if equation p has no \eqn{X_{(pj)}}}

\item{corr.e}{correlation matrix for continuous non-mixture or components of mixture error terms}

\item{U}{a list of length \code{M} of continuous non-mixture and components of mixture random effects}

\item{U_all}{a list of length \code{M} of continuous non-mixture and mixture random effects}

\item{rand.int}{"none" (default) if no random intercept term for all outcomes, "non_mix" if all random intercepts have a continuous
non-mixture distribution, "mix" if all random intercepts have a continuous mixture distribution;
also can be a vector of length \code{M} containing a combination (i.e., \code{c("non_mix", "mix", "none")} if the 1st has a non-mixture
distribution, the 2nd has a mixture distribution, and 3rd outcome has no random intercept)}

\item{rand.tsl}{"none" (default) if no random slope for time for all outcomes, "non_mix" if all random time slopes have a
continuous non-mixture distribution, "mix" if all random time slopes have a continuous mixture distribution; also can
be a vector of length \code{M} as in \code{rand.int}}

\item{corr.u}{if the random effects are the same variables across equations, a matrix of correlations for \eqn{U};
    if the random effects are different variables across equations, a list of length \code{M}, each component a list of length \code{M};
    \code{corr.u[[p]][[q]]} is matrix of correlations for random effects in equations p (\eqn{U_{(pj)}} for outcome \eqn{Y_p}) and
    q (\eqn{U_{(qj)}} for outcome \eqn{Y_q});
    if p = q, \code{corr.u[[p]][[q]]} is a correlation matrix with \code{nrow(corr.u[[p]][[q]])} = # \eqn{U_{(pj)}} for outcome \eqn{Y_p};
    if p != q, \code{corr.u[[p]][[q]]} is a non-symmetric matrix of correlations where rows correspond to \eqn{U_{(pj)}} for \eqn{Y_p}
    so that \code{nrow(corr.u[[p]][[q]])} = # \eqn{U_{(pj)}} for outcome \eqn{Y_p} and
    columns correspond to \eqn{U_{(qj)}} for \eqn{Y_q} so that \code{ncol(corr.u[[p]][[q]])} = # \eqn{U_{(qj)}} for outcome \eqn{Y_q};
    the number of random effects for \eqn{Y_p} is taken from \code{nrow(corr.u[[p]][[1]])} so that if there should be random effects,
    there must be entries for \code{corr.u};
    use \code{corr.u[[p]][[q]] = NULL} if equation q has no \eqn{U_{(qj)}}; use \code{corr.u[[p]] = NULL} if equation p has no \eqn{U_{(pj)}};

    correlations are specified in terms of components of mixture variables (if present);
    order is 1st random intercept (if \code{rand.int != "none"}), 2nd random time slope (if \code{rand.tsl != "none"}),
    3rd other random slopes with non-mixture distributions, 4th other random slopes with mixture distributions}

\item{rmeans2}{a list returned from \code{corrsys} or \code{corrsys2} which has the non-mixture and component means ordered according to
types of random intercept and time slope}

\item{rvars2}{a list returned like \code{rmeans}}
}
\value{
A list with the following components:

\code{cont_sum_y} a data.frame summarizing the simulated distributions of the \eqn{Y_p},

\code{cont_sum_e} a data.frame summarizing the simulated distributions of the non-mixture or components of mixture \eqn{E_p},

\code{target_sum_e} a data.frame summarizing the target distributions of the non-mixture or components of mixture \eqn{E_p},

\code{mix_sum_e} a data.frame summarizing the simulated distributions of the mixture \eqn{E_p},

\code{target_mix_e} a data.frame summarizing the target distributions of the mixture \eqn{E_p},

\code{rho.y} correlation matrix of dimension \code{M x M} for \eqn{Y_p}

\code{rho.e} correlation matrix for the non-mixture or components of mixture \eqn{E_p}

\code{rho.emix} correlation matrix for the mixture \eqn{E_p}

\code{rho.ye} matrix with correlations between \eqn{Y_p} (rows) and the non-mixture or components of mixture \eqn{E_p} (columns)

\code{rho.yemix} matrix with correlations between \eqn{Y_p} (rows) and the mixture \eqn{E_p} (columns)

\code{sum_xall} a data.frame summarizing \code{X_all} without the Time variable,

\code{rho.yx} a list of length \code{M}, where \code{rho.yx[[p]]} is matrix of correlations
    between \eqn{Y} (rows) and \code{X[[p]]} = \eqn{{X_ord(pj), X_cont(pj), X_comp(pj), X_pois(pj), X_nb(pj)}} (columns)

\code{rho.yxall} a list of length \code{M}, where \code{rho.yx[[p]]} is matrix of correlations
    between \eqn{Y} (rows) and \code{X_all[[p]]} (columns) not including \code{Time}

\code{rho.x} a list of length \code{M} of lists of length \code{M} where
    \code{rho.x[[p]][[q]] = cor(cbind(X[[p]], X[[q]]))} if p!= q or
    \code{rho.x[[p]][[q]] = cor(X[[p]]))} if p = q, where \code{X[[p]]} = \eqn{{X_ord(pj), X_cont(pj), X_comp(pj), X_pois(pj), X_nb(pj)}}

\code{rho.xall} a list of length \code{M} of lists of length \code{M} where
    \code{rho.xall[[p]][[q]] = cor(cbind(X_all[[p]], X_all[[q]]))} if p!= q or
    \code{rho.xall[[p]][[q]] = cor(X_all[[p]]))} if p = q, not including \code{Time}

\code{maxerr} a list of length \code{M} containing a vector of length \code{M} with the maximum correlation errors between outcomes,
    \code{maxerr[[p]]][q] = abs(max(corr.x[[p]][[q]] - rho.x[[p]][[q]]))}

Additional components vary based on the type of simulated variables:

If \bold{ordinal variables} are produced:
    \code{ord_sum_x} a list where \code{ord_sum_x[[j]]} is a data.frame summarizing \eqn{X_{ord(pj)}} for all p = 1, ..., \code{M}

If \bold{continuous variables} are produced:
    \code{cont_sum_x} a data.frame summarizing the simulated distributions of the \eqn{X_{cont(pj)}} and \eqn{X_comp(pj)},

    \code{target_sum_x} a data.frame summarizing the target distributions of the \eqn{X_{cont(pj)}} and \eqn{X_comp(pj)},

    \code{mix_sum_x} a data.frame summarizing the simulated distributions of the \eqn{X_{mix(pj)}},

    \code{target_mix_x} a data.frame summarizing the target distributions of the \eqn{X_{mix(pj)}}

If \bold{Poisson variables} are produced:
    \code{pois_sum_x} a data.frame summarizing the simulated distributions of the \eqn{X_{pois(pj)}}

If \bold{Negative Binomial variables} are produced:
    \code{nb_sum_x} a data.frame summarizing the simulated distributions of the \eqn{X_{nb(pj)}}

If \bold{random effects} are produced:
    \code{cont_sum_u} a data.frame summarizing the simulated distributions of the \eqn{U_{cont(pj)}} and \eqn{U_{comp(pj)}},

    \code{target_sum_u} a data.frame summarizing the target distributions of the \eqn{U_{cont(pj)}} and \eqn{U_{comp(pj)}},

    \code{sum_uall} a data.frame summarizing the simulated distributions of \code{U_all},

    \code{mix_sum_u} a data.frame summarizing the simulated distributions of the \eqn{U_{mix(pj)}},

    \code{target_mix_u} a data.frame summarizing the target distributions of the \eqn{U_{mix(pj)}},

    \code{rho.u} list of length \code{M}, each component a list of length \code{M};
    \code{rho.u[[p]][[q]] = cor(cbind(U[[p]], U[[q]]))} if p != q or \code{rho.u[[p]][[q]] = cor(U[[p]]))} if p = q

    \code{rho.uall} list of length \code{M}, each component a list of length \code{M};
    \code{rho.uall[[p]][[q]] = cor(cbind(U_all[[p]], U_all[[q]]))} if p != q or \code{rho.uall[[p]][[q]] = cor(U_all[[p]]))} if p = q

    \code{maxerr_u} list of length \code{M} containing a vector of length \code{M} with the maximum correlation errors for \eqn{U} between outcomes
    \code{maxerr_u[[p]]][q] = abs(max(corr.u[[p]][[q]] - rho.u[[p]][[q]]))}
}
\description{
This function summarizes the results of \code{\link[SimRepeat]{nonnormsys}}, \code{\link[SimRepeat]{corrsys}}, or
    \code{\link[SimRepeat]{corrsys2}}.  The inputs are either the simulated variables or inputs for those functions.  See their
    documentation for more information.  If only selected descriptions are desired, keep the non-relevant parameter inputs at their
    defaults.  For example, if only a description of the error terms are desired, \code{error_type = "non_mix"}, and
    \code{method = "Polynomial"}, specify \code{E, M, method, means, vars, skews, skurts, fifths, sixths, corr.e}.
}
\examples{
M <- 3
B <- calc_theory("Beta", c(4, 1.5))
skews <- lapply(seq_len(M), function(x) B[3])
skurts <- lapply(seq_len(M), function(x) B[4])
fifths <- lapply(seq_len(M), function(x) B[5])
sixths <- lapply(seq_len(M), function(x) B[6])
Six <- lapply(seq_len(M), function(x) list(0.03))
corr.e <- matrix(c(1, 0.4, 0.4^2, 0.4, 1, 0.4, 0.4^2, 0.4, 1), M, M,
  byrow = TRUE)
means <- lapply(seq_len(M), function(x) B[1])
vars <- lapply(seq_len(M), function(x) B[2]^2)
marginal <- list(0.3, 0.4, 0.5)
support <- lapply(seq_len(M), function(x) list(0:1))
corr.x <- list(list(matrix(1, 1, 1), matrix(0.4, 1, 1), matrix(0.4, 1, 1)),
  list(matrix(0.4, 1, 1), matrix(1, 1, 1), matrix(0.4, 1, 1)),
  list(matrix(0.4, 1, 1), matrix(0.4, 1, 1), matrix(1, 1, 1)))
betas <- list(0.5)
betas.t <- 1
betas.tint <- list(0.25)
Sys1 <- corrsys(10000, M, Time = 1:M, "Polynomial", "non_mix", means, vars,
  skews, skurts, fifths, sixths, Six, marginal = marginal, support = support,
  corr.x = corr.x, corr.e = corr.e, betas = betas, betas.t = betas.t,
  betas.tint = betas.tint, quiet = TRUE)
Sum1 <- summary_sys(Sys1$Y, Sys1$E, E_mix = NULL, Sys1$X, Sys1$X_all, M,
  "Polynomial", means, vars, skews, skurts, fifths, sixths,
  marginal = marginal, support = support, corr.x = corr.x, corr.e = corr.e)

\dontrun{
seed <- 276
n <- 10000
M <- 3
Time <- 1:M

# Error terms have a beta(4, 1.5) distribution with an AR(1, p = 0.4)
# correlation structure
B <- calc_theory("Beta", c(4, 1.5))
skews <- lapply(seq_len(M), function(x) B[3])
skurts <- lapply(seq_len(M), function(x) B[4])
fifths <- lapply(seq_len(M), function(x) B[5])
sixths <- lapply(seq_len(M), function(x) B[6])
Six <- lapply(seq_len(M), function(x) list(0.03))
error_type <- "non_mix"
corr.e <- matrix(c(1, 0.4, 0.4^2, 0.4, 1, 0.4, 0.4^2, 0.4, 1), M, M,
  byrow = TRUE)

# 1 continuous mixture of Normal(-2, 1) and Normal(2, 1) for each Y
mix_pis <- lapply(seq_len(M), function(x) list(c(0.4, 0.6)))
mix_mus <- lapply(seq_len(M), function(x) list(c(-2, 2)))
mix_sigmas <- lapply(seq_len(M), function(x) list(c(1, 1)))
mix_skews <- lapply(seq_len(M), function(x) list(c(0, 0)))
mix_skurts <- lapply(seq_len(M), function(x) list(c(0, 0)))
mix_fifths <- lapply(seq_len(M), function(x) list(c(0, 0)))
mix_sixths <- lapply(seq_len(M), function(x) list(c(0, 0)))
mix_Six <- list()
Nstcum <- calc_mixmoments(mix_pis[[1]][[1]], mix_mus[[1]][[1]],
  mix_sigmas[[1]][[1]], mix_skews[[1]][[1]], mix_skurts[[1]][[1]],
  mix_fifths[[1]][[1]], mix_sixths[[1]][[1]])

means <- lapply(seq_len(M), function(x) c(Nstcum[1], B[1]))
vars <- lapply(seq_len(M), function(x) c(Nstcum[2]^2, B[2]^2))

# 1 binary variable for each Y
marginal <- lapply(seq_len(M), function(x) list(0.4))
support <- list(NULL, list(c(0, 1)), NULL)

# 1 Poisson variable for each Y
lam <- list(1, 5, 10)
# Y2 and Y3 are zero-inflated Poisson variables
p_zip <- list(NULL, 0.05, 0.1)

# 1 NB variable for each Y
size <- list(10, 15, 20)
prob <- list(0.3, 0.4, 0.5)
# either prob or mu is required (not both)
mu <- mapply(function(x, y) x * (1 - y)/y, size, prob, SIMPLIFY = FALSE)
# Y2 and Y3 are zero-inflated NB variables
p_zinb <- list(NULL, 0.05, 0.1)

# The 2nd (the normal mixture) variable is the same across Y
same.var <- 2

# Create the correlation matrix in terms of the components of the normal
# mixture
K <- 5
corr.x <- list()
corr.x[[1]] <- list(matrix(0.1, K, K), matrix(0.2, K, K), matrix(0.3, K, K))
diag(corr.x[[1]][[1]]) <- 1
# set correlation between components to 0
corr.x[[1]][[1]][2:3, 2:3] <- diag(2)
# set correlations with the same variable equal across outcomes
corr.x[[1]][[2]][, same.var] <- corr.x[[1]][[3]][, same.var] <-
  corr.x[[1]][[1]][, same.var]
corr.x[[2]] <- list(t(corr.x[[1]][[2]]), matrix(0.35, K, K),
  matrix(0.4, K, K))
  diag(corr.x[[2]][[2]]) <- 1
  corr.x[[2]][[2]][2:3, 2:3] <- diag(2)
corr.x[[2]][[2]][, same.var] <- corr.x[[2]][[3]][, same.var] <-
  t(corr.x[[1]][[2]][same.var, ])
corr.x[[2]][[3]][same.var, ] <- corr.x[[1]][[3]][same.var, ]
corr.x[[2]][[2]][same.var, ] <- t(corr.x[[2]][[2]][, same.var])
corr.x[[3]] <- list(t(corr.x[[1]][[3]]), t(corr.x[[2]][[3]]),
  matrix(0.5, K, K))
diag(corr.x[[3]][[3]]) <- 1
corr.x[[3]][[3]][2:3, 2:3] <- diag(2)
corr.x[[3]][[3]][, same.var] <- t(corr.x[[1]][[3]][same.var, ])
corr.x[[3]][[3]][same.var, ] <- t(corr.x[[3]][[3]][, same.var])

# The 2nd and 3rd variables of each Y are subject-level variables
subj.var <- matrix(c(1, 2, 1, 3, 2, 2, 2, 3, 3, 2, 3, 3), 6, 2, byrow = TRUE)
int.var <- tint.var <- NULL
betas.0 <- 0
betas <- list(seq(0.5, 0.5 + (K - 2) * 0.25, 0.25))
betas.subj <- list(seq(0.5, 0.5 + (K - 2) * 0.1, 0.1))
betas.int <- list()
betas.t <- 1
betas.tint <- list(c(0.25, 0.5))

method <- "Polynomial"

# Check parameter inputs
checkpar(M, method, error_type, means, vars, skews, skurts, fifths, sixths,
  Six, mix_pis, mix_mus, mix_sigmas, mix_skews, mix_skurts, mix_fifths,
  mix_sixths, mix_Six, marginal, support, lam, p_zip, pois_eps = list(),
  size, prob, mu, p_zinb, nb_eps = list(), corr.x, corr.yx = list(),
  corr.e, same.var, subj.var, int.var, tint.var, betas.0, betas,
  betas.subj, betas.int, betas.t, betas.tint)

# Simulated system using correlation method 1
N <- corrsys(n, M, Time, method, error_type, means, vars, skews, skurts,
  fifths, sixths, Six, mix_pis, mix_mus, mix_sigmas, mix_skews, mix_skurts,
  mix_fifths, mix_sixths, mix_Six, marginal, support, lam, p_zip, size,
  prob, mu, p_zinb, corr.x, corr.e, same.var, subj.var, int.var, tint.var,
  betas.0, betas, betas.subj, betas.int, betas.t, betas.tint, seed = seed,
  use.nearPD = FALSE)

# Summarize the results
S <- summary_sys(N$Y, N$E, E_mix = NULL, N$X, N$X_all, M, method, means,
  vars, skews, skurts, fifths, sixths, mix_pis, mix_mus, mix_sigmas,
  mix_skews, mix_skurts, mix_fifths, mix_sixths, marginal, support, lam,
  p_zip, size, prob, mu, p_zinb, corr.x, corr.e)
S$sum_xall
S$maxerr
}

}
\references{
See references for \code{\link[SimRepeat]{SimRepeat}}.
}
\seealso{
\code{\link[SimRepeat]{nonnormsys}}, \code{\link[SimRepeat]{corrsys}}, \code{\link[SimRepeat]{corrsys2}}
}
\keyword{summary}
