% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_grid.R
\name{make_grid}
\alias{make_grid}
\title{Make a depth stratified survey grid}
\usage{
make_grid(
  x_range = c(-140, 140),
  y_range = c(-140, 140),
  res = c(3.5, 3.5),
  shelf_depth = 200,
  shelf_width = 100,
  depth_range = c(0, 1000),
  n_div = 1,
  strat_breaks = seq(0, 1000, by = 40),
  strat_splits = 2,
  method = "spline"
)
}
\arguments{
\item{x_range}{Range (min x, max x) in x dimension in km}

\item{y_range}{Range (min y, max y) in y dimension in km}

\item{res}{Resolution, in km, of the grid cells}

\item{shelf_depth}{Approximate depth of the shelf in m}

\item{shelf_width}{Approximate width of the shelf in km}

\item{depth_range}{Range (min depth, max depth) in depth in m}

\item{n_div}{Number of divisions to include}

\item{strat_breaks}{Define strata given these depth breaks}

\item{strat_splits}{Number of times to horizontally split strat (i.e. easy way to increase the number of strata)}

\item{method}{Use a "spline", "loess" or "bezier" to generate a smooth gradient or simply use "linear" interpolation?}
}
\value{
Returns RasterBrick of the same structure as \code{\link{survey_grid}}
}
\description{
This function sets up a depth stratified survey grid. A simple gradient in depth
is simulated using \code{\link{spline}} with a shallow portion, shelf and
deep portion. Adding covariance to the depth simulation is an option.
}
\examples{

r <- make_grid(res = c(10, 10))
raster::plot(r)

p <- raster::rasterToPolygons(r$strat, dissolve = TRUE)
sp::plot(p)

}
