% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss.ca.R
\name{ss.study.ca}
\alias{ss.study.ca}
\title{Graphs and figures for a Capability Study}
\usage{
ss.study.ca(xST, xLT = NA, LSL = NA, USL = NA, Target = NA, 
  alpha = 0.05, f.na.rm = TRUE, f.main = "Six Sigma Capability Analysis Study", 
  f.sub = "", f.colours = c("#4682B4","#d1d1e0","#000000","#00C800","#FF0000"))
}
\arguments{
\item{xST}{Short Term process performance data}

\item{xLT}{Long Term process performance data}

\item{LSL}{Lower Specification Limit of the process}

\item{USL}{Upper Specification Limit of the process}

\item{Target}{Target of the process}

\item{alpha}{Type I error for the Confidence Interval}

\item{f.na.rm}{If TRUE NA data will be removed}

\item{f.main}{Main Title for the graphic output}

\item{f.sub}{Subtitle for the graphic output}

\item{f.colours}{Vector of colours fot the graphic output}
}
\value{
Figures and plot for Capability Analysis
}
\description{
Plots a Histogram with density lines about the data of a process. Check normality
with qqplot and normality tests. Shows the Specification Limits and the 
Capability Indices.
}
\note{
The argument \code{f.colours} takes a vector of colours for the graphical outputs. The order of 
the elements are, first the colour for histogram bars, then Density ST lines, Density LT 
lines, Target, and Specification limits. It can be partially specified.
}
\examples{

 ss.study.ca(ss.data.ca$Volume, rnorm(40, 753, 3), 
		LSL = 740, USL = 760, T = 750, alpha = 0.05, 
 			f.sub = "Winery Project")
 			
 ss.study.ca(ss.data.ca$Volume, rnorm(40, 753, 3), 
		LSL = 740, USL = 760, T = 750, alpha = 0.05, 
 			f.sub = "Winery Project", 
 			f.colours = c("#990000", "#007700", "#002299"))
 			
}
\references{
Cano, Emilio L., Moguerza, Javier M. and Redchuk, Andres. 2012.
\emph{Six Sigma with {R}. Statistical Engineering for Process
  Improvement}, Use R!, vol. 36. Springer, New York.
  \url{https://www.springer.com/gp/book/9781461436515}.
  
Montgomery, DC (2008) \emph{Introduction to Statistical Quality Control}
  (Sixth Edition). New York: Wiley&Sons
}
\seealso{
\code{\link{ss.ca.cp}}
}
\author{
Main author: Emilio L. Cano. Contributions by Manu Alfaro.
}
