% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dframeEquiv.R
\name{dframeEquiv}
\alias{dframeEquiv}
\title{Examines the equivalence of two dataframes or matrices}
\usage{
dframeEquiv(d1, d2, maxAbsError = 1e-12, maxRelError = 1e-14,
  verbose = TRUE)
}
\arguments{
\item{d1}{The first dataframe or matrix}

\item{d2}{The dataframe or matrix that will be compared to \code{d1}}

\item{maxAbsError}{Numeric values whose absolute difference is less than
\code{maxAbsError} will be declared equivalent}

\item{maxRelError}{Numeric values whose relative difference is within
\code{maxRelError} will be declared equivalent}

\item{verbose}{\code{=TRUE} prints the result of the comparison}
}
\value{
Invisibly returns a list with the following components.  (If the
matrices do not have the same dimensions or the same colnames and rownames,
then \code{frac.equiv}, \code{loc.equiv}, and \code{equiv.matrix} are all
\code{NULL}).  \item{equiv}{\code{=TRUE} if \code{d1} is equivalent to
\code{d2}} \item{msg}{Messages that describe the comparison.  (These are
printed when \code{verbose=TRUE}.)} \item{frac.equiv}{The fraction of
matrix elements that are equivalent} \item{loc.inequiv}{A data frame
indicating the row and column coordinate locations of the elements that are
not equivalent} \item{eqiv.matrix}{A boolean matrix with the same dimension
as \code{d1} and \code{d2}, indicating the equivalent elements}
}
\description{
Checks whether two data objects (data frames and/or matrices) are
equivalent and returns a descriptive message describing the result.
}
\details{
\code{d1} and \code{d2} do not both have to be of the same mode; i.e.
\code{d1} could be a dataframe and \code{d2} could be a matrix.  If the
number of rows or the number of columns differ, then no further comparisons
are made.  If the colnames or rownames differ, then those differences are
noted and comparison continues.  If two corresponding elements are both
\code{NA}, then they are considered equivalent.  Likewise, \code{Inf} is
considered equivalent to \code{Inf} and \code{-Inf} is considered
equivalent to \code{-Inf}.  Factors in dataframes are converted to
character strings prior to comparison.  Comparisons are made one column at
a time.

If a particular column from both objects are numeric, then for two
corresponding values, say, \code{a} and \code{b}, equivalence is declared
if one or more of the following occurs: 1) \code{a == b}, 2) \code{abs(a -
b) < maxAbsError}, 3) \code{abs((a - b) / b) < maxRelError} if \code{abs(b)
> abs(a)}, or \code{abs((a - b) / a) < maxRelError} if \code{abs(b) >=
abs(a)}.

If both columns are not numeric, they are coerced (if need be) to character
and then compared directly.
}
\examples{

# Number of rows different
dframeEquiv(matrix(rnorm(20), nrow = 4),
            matrix(rnorm(25), nrow = 5))

# Number of columns different
dframeEquiv(matrix(rnorm(16), nrow = 4),
            matrix(rnorm(20), nrow = 4))

# Rownames differ
dframeEquiv(matrix(rnorm(9), nrow = 3, dimnames = list(1:3, NULL)),
            matrix(rnorm(9), nrow = 3, dimnames = list(letters[1:3], NULL)))

# Colnames differ
dframeEquiv(matrix(rnorm(9), nrow = 3, dimnames = list(NULL, 1:3)),
            matrix(rnorm(9), nrow = 3, dimnames = list(NULL, letters[1:3])))

# Not equivalent
x <- data.frame(x = factor(c(1,1,2,2,3,3)), y = rnorm(6))
y <- data.frame(x = factor(c(1,2,2,2,3,3)), y = c(x$y[-6],rnorm(1)))
dframeEquiv(x, y)

# Look at discrepancies
out <- dframeEquiv(x, y)
out

# Equivalent
x <- data.frame(x = letters[1:6], y = 0:5)
y <- x
dframeEquiv(x, y)

}
\author{
Landon Sego
}
\references{
\url{http://www.cygnus-software.com/papers/comparingfloats/comparingfloats.htm}
}
\seealso{
\code{\link{all.equal}}, \code{\link{identical}}
}
\keyword{misc}

