% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_pcntile_fun.R
\name{w_pcntile}
\alias{w_pcntile}
\title{Function to create population weighted deprivation percentiles}
\usage{
w_pcntile(data, population, variable, p = 10, low = FALSE)
}
\arguments{
\item{data}{name of the dataset}

\item{population}{distribution (in numbers)}

\item{variable}{the deprivation measure to calculate the percentiles for}

\item{p}{the number of percentiles/groups to split the data in. Default is deciles \code{p=10}.}

\item{low}{should low values of the percentile correspond to high deprivation, defaults to FALSE --
higher values correspond to higher deprivation}
}
\value{
Numeric vector of percentiles (default 1 to 10) of same length as \code{population} and \code{variable}
}
\description{
Function to create population weighted deprivation percentiles
}
\examples{
data <- dep_data

#calculate deciles for overcrowding
data$dec_overcrowd <- w_pcntile(data, total_pop, pcnt_overcrowding)

#average percent of overcrowding by decile
tapply(data$pcnt_overcrowding, data$dec_overcrowd, mean)

#percent of people in each decile
round(tapply(data$total_pop, data$dec_overcrowd, sum)/sum(data$total_pop)*100, 1)

#calculate quintiles from deciles
data$Q_overcrowd <- cut(data$dec_overcrowd, breaks = 5, labels = 1:5)

#calculate quintiles with w_pcntile
data$Q_overcrowd2 <- w_pcntile(data, total_pop, pcnt_overcrowding, p = 5)

#compare results - note small differences
table(data$Q_overcrowd, data$Q_overcrowd2)
}
