% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Authenticate.R
\name{SaveCredential}
\alias{LoadCredential}
\alias{SaveCredential}
\title{Save and load credential information}
\usage{
SaveCredential(credential, filename = "credential.RDS")

LoadCredential(filename = "credential.RDS")
}
\arguments{
\item{credential}{\code{credential} object}

\item{filename}{character, filename to be saved to or restored from}
}
\value{
\code{credential} object
}
\description{
Functions to save and load credential information. Currently, credential
information will be stored as a RDS file. \code{SaveCredential} will return
the input \code{credential}, useful for working as a filter between the
\code{Authenticate} and \code{Collect}.
}
\note{
\code{credential} created from \code{Authenticate} with socialmedia =
'twitter' will not be saved by SaveCredential
}
\examples{
\dontrun{
require(magrittr)
myAppID <- "123456789098765"
myAppSecret <- "abc123abc123abc123abc123abc123ab"
myUsernames <- c("senjohnmccain","obama")

Authenticate("instagram",
appID = myAppId,
appSecret = myAppSecret) \%>\% SaveCredential("instagramCred.RDS") \%>\% Collect(ego = TRUE,
username = myUsernames) \%>\% Create

## Load the previously saved credential information
LoadCredential("instagramCred.RDS") \%>\% Collect(tag="obama",
distance=5000, n=100) \%>\% Create("bimodal")
}
}

