% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softbart_regression.R
\name{softbart_regression}
\alias{softbart_regression}
\title{SoftBart Regression}
\usage{
softbart_regression(
  formula,
  data,
  test_data,
  num_tree = 20,
  k = 2,
  hypers = NULL,
  opts = NULL,
  verbose = TRUE
)
}
\arguments{
\item{formula}{A model formula with a numeric variable on the left-hand-side and predictors on the right-hand-side.}

\item{data}{A data frame consisting of the training data.}

\item{test_data}{A data frame consisting of the testing data.}

\item{num_tree}{The number of trees in the ensemble to use.}

\item{k}{Determines the standard deviation of the leaf node parameters, which is given by \code{3 / k / sqrt(num_tree)}.}

\item{hypers}{A list of hyperparameters constructed from the \code{Hypers()} function (\code{num_tree}, \code{k}, and \code{sigma_mu} are overridden by this function).}

\item{opts}{A list of options for running the chain constructed from the \code{Opts()} function (\code{update_sigma} is overridden by this function).}

\item{verbose}{If \code{TRUE}, progress of the chain will be printed to the console.}
}
\value{
Returns a list with the following components:
\itemize{
  \item \code{sigma_mu}: samples of the standard deviation of the leaf node parameters.
  \item \code{sigma}: samples of the error standard deviation.
  \item \code{var_counts}: a matrix with a column for each predictor group containing the number of times each predictor is used in the ensemble at each iteration.
  \item \code{mu_train}: samples of the nonparametric function evaluated on the training set.
  \item \code{mu_test}: samples of the nonparametric function evaluated on the test set.
  \item \code{mu_train_mean}: posterior mean of \code{mu_train}.
  \item \code{mu_test_mean}: posterior mean of \code{mu_test}.
  \item \code{formula}: the formula specified by the user.
  \item \code{ecdfs}: empirical distribution functions, used by the \code{predict} function.
  \item \code{opts}: the options used when running the chain.
  \item \code{mu_Y, sd_Y}: used with the predict function to transform predictions.
  \item \code{forest}: a forest object; see the \code{MakeForest} documentation for more details.
}
}
\description{
Fits a semiparametric regression model with the nonparametric function
modeled using a SoftBart model.
}
\examples{

## NOTE: SET NUMBER OF BURN IN AND SAMPLE ITERATIONS HIGHER IN PRACTICE

num_burn <- 10 ## Should be ~ 5000
num_save <- 10 ## Should be ~ 5000

set.seed(1234)
f_fried <- function(x) 10 * sin(pi * x[,1] * x[,2]) + 20 * (x[,3] - 0.5)^2 + 
  10 * x[,4] + 5 * x[,5]

gen_data <- function(n_train, n_test, P, sigma) {
  X <- matrix(runif(n_train * P), nrow = n_train)
  mu <- f_fried(X)
  X_test <- matrix(runif(n_test * P), nrow = n_test)
  mu_test <- f_fried(X_test)
  Y <- mu + sigma * rnorm(n_train)
  Y_test <- mu + sigma * rnorm(n_test)
  
  return(list(X = X, Y = Y, mu = mu, X_test = X_test, Y_test = Y_test, 
              mu_test = mu_test))
}

## Simiulate dataset
sim_data <- gen_data(250, 250, 100, 1)

df <- data.frame(X = sim_data$X, Y = sim_data$Y)
df_test <- data.frame(X = sim_data$X_test, Y = sim_data$Y_test)

## Fit the model

opts <- Opts(num_burn = num_burn, num_save = num_save)
fitted_reg <- softbart_regression(Y ~ ., df, df_test, opts = opts)

## Plot results

plot(colMeans(fitted_reg$mu_test), sim_data$mu_test)
abline(a = 0, b = 1)
}
