% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoftObservation.R
\name{SoftObservation}
\alias{SoftObservation}
\title{Recording the prediction weights to analyze observation-level patterns}
\usage{
SoftObservation(response, responselabel = "No Variable Label", train,
  depth, keep = TRUE, observation, export = FALSE, path = NA)
}
\arguments{
\item{response}{A vector of responses \code{0} and \code{1} for a single classification for the training set with length equal to the number of observations in the training set and width \code{1}.}

\item{responselabel}{A character string of the title of the response variable used.}

\item{train}{A matrix or data frame consisting of the entire dataset to train.}

\item{depth}{A numeric of the number of the depth each SDT should be.  Here this ends with \eqn{2^{depth - 1}} terminal nodes.}

\item{keep}{A logical passed to the internal functions to keep the prediction and weights (TRUE) or discard the weights and keep only prediction (FALSE).}

\item{observation}{A numeric or vector containing observations of interest to keep the fitted prediction probability and weights.}

\item{export}{A logical indicating if results should be printed directly (FALSE) or exported to csv (TRUE).}

\item{path}{A directory location to save the exported csv file.  Must be provided if export = TRUE.}
}
\value{
A list of possible elements
\item{Prediction}{A vector of fitted probabilities for the given classification and observation(s).}
\item{AllFeatures}{A numeric list of Features chosen at each node where the number represents the column number in the data.}
\item{AllWeights}{A matrix of weights where the rows represent the observations and columns represent the weights used at different stages.} 
\item{SoftObservationDataOutput.csv}{If export = TRUE, this csv file can be used with an Excel supplement to create visual displays of a single observation for a single response.}
}
\description{
\code{SoftObservation} runs the depth given of a single SDT of a single response focusing on a single (or a few) observations
in order to make inference from the Prediction Weights found.
}
\details{
\code{SoftObservation} runs the internal SoftForestPredDepth functions so that a single SDT's weights can be recorded.
This can then be exported to any tree visual representation to see how the observation(s) of interest pass through the SDT
This follows from the other user interface function SoftClassForest where the test set is the observation of interest
instead of being used for testing misclassification.  Exporting these weights for visual representation is possible and recommended.
}
\examples{
Responses = SoftClassMatrix(as.vector(iris$Species))
SoftObservation(response = Responses[,1], responselabel = "setosa", train = iris[,1:4], 
depth = 2, keep = TRUE, observation = 34, export = TRUE, path = tempdir())
}
