% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DK_to_SWC.R
\name{DK_to_SWC}
\alias{DK_to_SWC}
\title{Calculate Soil Water Content from dielectric constant}
\usage{
DK_to_SWC(
  DK,
  FUN = c("topp", "jacobsen", "jacobsen_soil_prop", "pepin_5cm", "pepin", "roth_org",
    "malicki_bd", "malicki_ths", "myllys", "myllys_sphagnum", "myllys_carex", "kellner",
    "kellner_h2", "kellner_h3", "kellner_h4", "beckwith", "yoshikawa_deadmoss",
    "yoshikawa_livemoss", "nagare", "oleszczuk", "gs3"),
  bd,
  ths,
  clay,
  SOM
)
}
\arguments{
\item{DK}{dielectric constant}

\item{FUN}{character string specifying the polynominal function. See details.}

\item{bd}{bulk density [g/cm³] (needed for FUN == 'malicki_bd' and 'jacobsen_soil_prop')}

\item{ths}{porosity or saturated water content [L³/L³] (needed for 'malicki_ths')}

\item{clay}{content of clay [percent] (only needed for 'jacobsen')}

\item{SOM}{soil organic matter [percent] (for 'jacobsen_soil_prop')}
}
\value{
data.table with columns DK, SWC and FUN.
}
\description{
Calculate volumetric soil water content (SWC [L³/L³] from dielectric constant (DK) using different equations (e.g. Topp et al. 1980).
Contains mainly functions for peat and other organic soils.
}
\details{
Possible functions (FUN) are': \cr
\describe{\item{'topp'}{Topp et al. (1980)}}
\describe{\item{'jacobsen'}{Jacobsen and Schjonning (1993), equation 2}}
\describe{\item{'jacobsen_soil_prop'}{Jacobsen and Schjonning (1993), equation 3 (bd, ths and SOM are required as input)}}
\describe{\item{'pepin_5cm'}{Pepin, S. et al. (1992), Table 2 Depth 5 cm}}
\describe{\item{'pepin'}{Pepin, S. et al. (1992), Table 2 Pooled data}}
\describe{\item{'roth_org'}{Roth et al. (1992), Tabel 3c}}
\describe{\item{'malicki_bd'}{Malicki, M.A. et al. (1996), equation 10 (bd is required as input)}}
\describe{\item{'malicki_ths'}{Malicki, M.A. et al. (1996), equation 12 (ths is required as input)}}
\describe{\item{'myllys'}{Myllys M. and Simojoki, A. (1996), Table 2 pooled}}
\describe{\item{'myllys_sphagnum'}{Myllys M. and Simojoki, A. (1996), Table 2 Sphagnum}}
\describe{\item{'myllys_carex'}{Myllys M. and Simojoki, A. (1996), Table 2 Carex}}
\describe{\item{'kellner'}{Kellner E., Lundin L.C. (2001), Table 2 Pooled data}}
\describe{\item{'kellner_h2'}{Kellner E., Lundin L.C. (2001), Table 2 H2}}
\describe{\item{'kellner_h3'}{Kellner E., Lundin L.C. (2001), Table 2 H3}}
\describe{\item{'kellner_h4'}{Kellner E., Lundin L.C. (2001), Table 2 H4}}
\describe{\item{'beckwith'}{Beckwith C.W. and Baird A.J. (2001), eq. 1}}
\describe{\item{'yoshikawa_deadmoss'}{from Tabel 1 in Nagare et al. (2001)}}
\describe{\item{'yoshikawa_livemoss'}{from Tabel 1 in Nagare et al. (2001)}}
\describe{\item{'nagare'}{Nagare et al. (2011), combined from Table 4}}
\describe{\item{'oleszczuk'}{from Table 1 in Oleszczuk et al. (2004)}}
\describe{\item{'gs3'}{Meter group, eq. 7}}
}
\references{
Beckwith C.W., Baird A.J. (2001): Effect of biogenic gas bubbles on water flow through poorly decomposed blanket peat. Water Resour. Res., 37(3), 551-558.

Decagon Device (2016): GS3 Water Content, EC an Temperature Sensors, Operators maual , Decagon Device, Inc 2365 NE Hopkins Court Pullman WA 99163.\cr

Jacobsen, O.H., Schjonning, P. (1993): A laboratory calibration of time domain reflectometry for soil water measurement including effects of bulk density and texture. Journal of Hydrology, 151(2-4), 147-157. \cr

Kellner E., Lundin L.C. (2001): Calibration of Time Domain Reflectometry for Water Content in Peat Soil, Uppsala University, Dept. of Earth Sciences/Hydrology,SE-752 36 Uppsala, Sweden. Hydrology Research, 32(4-5), 315-332.\cr

Malicki, M.A., Plagge, R., Roth, C.H. (1996): Improving the calibration of dielectric TDR soil moisture determination taking into account the solid soil. European Journal of Soil Science, 47:357-366.

Meter group: Operator manual GS3 (http://library.metergroup.com/Manuals/20429_GS3_Web.pdf)

Myllys M., Simojoki, A. (1996): Calibration of time domain reflectometry (TDR) for soil moisture measuremnts in cultivated peat soils, Agricultural Research centre of Finland, Institut of Cropand Soil Science, University of helsinki, Department of Applied Chemistry and Mircrobiology.\cr

Nagare, R.M., Schincariol, R. A., Quinton, W.L., Hayashi, M. (2011): Laboratory calibration of time domain reflectometry to determine moisture content in undisturbed peat samples. European journal of soil science, 62(4), 505-515. \cr

Oleszczuk R., Brandyk T., and Szatylowicz J., 1998: Possibilities of TDR method application to measure moisture content of peat-muck soil (in Polish). Zesz. Prob. Post. Nauk Roln., 458, 263-274. \cr

Oleszczuk, R., Brandyk, T., Gnatowski, T., & Szatylowicz, J. (2004). Calibration of TDR for moisture determination in peat deposits. International agrophysics, 18(2). \cr

Pepin, S., Plamondon, A.P., and Stein, J. (1992): Peat water-content measurement using time domain reflectrometry, Can. J. of Forest Res., Vol. 22, pp. 534-540\cr

Roth C.H., M.A. Malicki, R. Plagge (1992): Empirical evaluation of the relationship between soil dielectric constant and volumetric water content as the basis for calibration soil moisture measurements by TDR; Institute of Ecology, Technical University of Berlin, Berlin, Germany and *Polish Academy of sciences, Institute of Agrophysics, ul. Doswiadczalna 4, 20-236 Lublin, Poland; Journal of Soil Science, 1992, 43, 1-13.\cr

Topp, G.C., Davis, J.L., Annan, A.P. (1980): Electromagnetic determination of soil water content: Measurements in coaxial transmission lines. Water resources research, 16(3), 574-582. \cr

Yoshikawa, K., Overduin, P., Harden, J. (2004): Moisture content measurements of moss (Sphagnum spp.) using commercial sensors. Permafrost Periglac, 15, 309-318.\cr
}
