% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{getC,Model-method}
\alias{getC,Model-method}
\title{Pool Contents for all times}
\usage{
\S4method{getC}{Model}(object)
}
\arguments{
\item{object}{A modelrun as produced by the constructors: 
 \code{\link{Model}},
 \code{\link{Model_by_PoolNames}},
 \code{\link{Model_14}}
the function \code{\link{GeneralModel}} or the functions listed in 
\code{\link{predefinedModels}}. \cr
A model represents the initial value problem (IVP)  
for the contents of the pool consisting of 
\itemize{
 \item{ The initial values of the pool content}
 \item{ The system of ordinary differential equations, as dictated by the fluxes}
 \item{ The times for which the solution of the IVP is evaluated.}
}}
}
\value{
A matrix with as many columns as there are pools 
and as many rows as there are entries in the \code{times} argument the model has been build with.
}
\description{
Pool Contents for all times

The solution of the initial value problem (IVP) for the pool contents.
Since the first models in SoilR had only Carbon pools 
the function name \code{getC} could be interpreted as 
referring to the C content. If the model includes other 
element cycles e.g. N or P this interpretation is no longer 
valid. In this case the C in 'getC' stands for 'content' 
since the function will always return the solution for 
all pools, regardless of the chemical element the author of 
the model associated them with.
}
