% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseFamily.R
\name{parse_family}
\alias{parse_family}
\title{Parse components of a family-level taxon name}
\usage{
parse_family(family)
}
\arguments{
\item{family}{a character vector containing taxonomic families, e.g. \code{"fine-loamy, mixed, semiactive, mesic ultic haploxeralfs"}}
}
\value{
a \code{data.frame} containing column names: \code{"family"} (input), \code{"subgroup"} (parsed taxonomic subgroup), \code{"subgroup_code"} (letter code for subgroup), \code{"class_string"} (comma-separated family classes), \code{"classes_split"} (split class_string vector stored as \code{list} column)
}
\description{
Parse components of a family-level taxon name
}
\examples{

families <- c("fine, kaolinitic, thermic typic kanhapludults",
              "fine-loamy, mixed, semiactive, mesic ultic haploxeralfs",
              "euic, thermic typic haplosaprists",
              "coarse-loamy, mixed, active, mesic aquic dystrudepts",
              "fine, kaolinitic, thermic typic kanhapludults",
              "fine-loamy, mixed, semiactive, mesic ultic haploxeralfs",
              "euic, thermic typic haplosaprists",
              "coarse-loamy, mixed, active, mesic aquic dystrudepts")
 
# inspect parsed list result             
str(parse_family(families))     

}
