% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-annotations.R
\name{read_annotations}
\alias{read_annotations}
\title{Import a SomaLogic Annotations File}
\usage{
read_annotations(file)
}
\arguments{
\item{file}{A path to an annotations file location.
This is a sanctioned, versioned file provided by
Standard BioTools, Inc. and should be an \emph{unmodified}
\verb{*.xlsx} file.}
}
\value{
A \code{tibble} containing analyte-specific annotations and
related (e.g. lift/bridging) information, keyed on SomaLogic
\link{SeqId}, the unique SomaScan analyte identifier.
}
\description{
Import a SomaLogic Annotations File
}
\examples{
\dontrun{
  # for example
  file <- "~/Downloads/SomaScan_11K_Annotated_Content.xlsx"
  anno_tbl <- read_annotations(file)
}
}
