% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{CAplot}
\alias{CAplot}
\title{Distribution plotting}
\usage{
CAplot(var, output, xlim = NULL, ylim = NULL, main = NULL,
  sub = NULL, xlab = NULL, ylab = NULL)
}
\arguments{
\item{var}{The variable in interest after having been sorted. Must be specified as a character.}

\item{output}{Output of \code{CA} command.}

\item{xlim}{x-axis limits. Default is range of percentile index.}

\item{ylim}{y-axis limits. Default is NULL.}

\item{main}{Main title of the plot. Defualt is NULL.}

\item{sub}{Sub title of the plot. Default is NULL.}

\item{xlab}{x-axis label. Default is "Percentile Index".}

\item{ylab}{y-axis label. Default is "Sorted Effects".}
}
\description{
\code{CAplot} plots distributions and joint uniform confidence bands of variables in interest from \code{\link{CA}} command.
}
\examples{
data("mortgage")
fm <- deny ~ black + p_irat
t <- c(rep(1, 2), rep(0, 14)) # Specify variables in interest
cl <- matrix(c(1,0,0,1), nrow=2) # Meaning: show variables in interest for both groups
# Drawing Distributions
CAgraph <- CA(fm=fm, data = mortgage, var.T = "black", method = "logit", cl = cl,
              t = t, interest = "dist")
CAplot(var = "p_irat", output = CAgraph)

}
