% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{GetShuffledCT}
\alias{GetShuffledCT}
\title{Perform a Deranged Shuffle of Cell Types}
\usage{
GetShuffledCT(CellType)
}
\arguments{
\item{CellType}{A character vector representing the cell types to be shuffled.}
}
\value{
A character vector of the same length as `CellType`, with elements shuffled such that no element remains in its original position.
}
\description{
This function takes a vector of cell types and returns a shuffled version where no element remains in its original position.
}
\examples{
\donttest{
original <- c("B_cell", "T_cell", "NK_cell", "Macrophage")
shuffled <- GetShuffledCT(original)
print(shuffled)
}

}
