% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restart.R
\name{restartSpades}
\alias{restartSpades}
\title{Restart an interrupted simulation}
\usage{
restartSpades(sim = NULL, module = NULL, numEvents = Inf,
  restart = TRUE, ...)
}
\arguments{
\item{sim}{A simList. If not supplied (the default), this will take the sim from
\code{SpaDES.core:::.pkgEnv$.sim}, i.e., the one that was interrupted}

\item{module}{A character string length one naming the module that caused the error and
whose source code was fixed. This module will be reparsed and placed into the simList}

\item{numEvents}{Numeric. Default is Inf (i.e., all available). In the \code{simList}, if
\code{options('spades.recoveryMode')} is set to \code{TRUE} or a numeric, then
there will be a list in the \code{simList} called \code{.recoverableObjs}. These will be
replayed backwards in time to reproduce the initial state of the simList before
the event that is \code{numEvents} back from the first event in \code{events(sim)}.}

\item{restart}{Logical. If \code{TRUE}, then the call to \code{spades} will be made, i.e.,
restarting the simulation. If \code{FALSE}, then it will return a new \code{simList}
with the module code parsed into the \code{simList}}

\item{...}{Passed to \code{spades}, e.g., \code{debug}, \code{.plotInitialTime}}
}
\value{
A simList as if \code{spades} had been called on a simList.
}
\description{
This is very experimental and has not been thoroughly tested. Use with caution.
This function will reparse a single module (currently) into the \code{simList}
where its source code should reside, and then optionally restart a simulation
that stopped on an error, presumably after the developer has modified the
source code of the module that caused the break.
This will restart the simulation at the next event in the event queue
(i.e., returned by \code{events(sim)}). Because of this, this function will
not do anything if the event queue is empty.
}
\details{
This will only parse the source code from the named module. It will not affect any
objects that are in the \code{mod} or \code{sim}.

The random number seed will be reset to the state it was at the start of the
earliest event recovered, thereby returning to the exact stochastic simulation
trajectory.
}
\note{
This will only work reliably
\emph{if the simList was not modified yet during the event which caused the error}.
The \code{simList} will be in the state it was at the time of the error.
}
\examples{
\dontrun{
# options("spades.recoveryMode" = 1) # now the default
s <- simInit()
s <- spades(s) # this this is interrupted or fails
s <- restartSpades() # don't need to put simList
                     # will take from SpaDES.core:::.pkgEnv$.sim automatically
}
}
