% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{saveFiles}
\alias{saveFiles}
\title{Save objects using \code{.saveObjects} in \code{params} slot of \code{simInit}}
\usage{
saveFiles(sim)
}
\arguments{
\item{sim}{A \code{simList} simulation object.}
}
\description{
In the \code{\link{simInit}} call, a parameter called \code{.saveObjects} can be provided in
each module.
This must be a character string vector of all object names to save. These objects will
then be saved whenever a call to \code{saveFiles} is made.
}
\details{
The file names will be equal to the object name plus \code{time(sim)} is
appended at the end.
The files are saved as \code{.rds} files, meaning, only one object gets
saved per file.


For objects saved using this function, the module developer must create save
events that schedule a call to \code{saveFiles}.

If this function is used outside of a module, it will save all files in the
outputs(sim) that are scheduled to be saved at the current time in the simList.

There are 3 ways to save objects using \code{SpaDES}.
}
\note{
It is not possible to schedule separate saving events for each object
that is listed in the \code{.saveObjects}.
}
\section{1. Model-level saving}{


Using the \code{outputs} slot in the \code{\link{simInit}} call.
See example in \code{\link{simInit}}.
This can be convenient because it gives overall control of many modules at a
time, and it gets automatically scheduled during the
\code{\link{simInit}} call.
}

\section{2. Module-level saving}{


Using the \code{saveFiles} function inside a module.
This must be accompanied by a \code{.saveObjects} list element in the
\code{params} slot in the \code{\link{simList}}.
Usually a module developer will create this method for future users of
their module.
}

\section{3. Custom saving}{


A module developer can save any object at any time inside their module, using
standard R functions for saving R objects (e.g., \code{save} or \code{saveRDS}).
This is the least modular approach, as it will happen whether a module user
wants it or not.
}

\examples{
\dontrun{

# This will save the "caribou" object at the save interval of 1 unit of time
#  in the outputPath location
outputPath <- file.path(tempdir(), "test_save")
times <- list(start = 0, end = 6, "month")
parameters <- list(
  .globals = list(stackName = "landscape"),
  caribouMovement = list(
    .saveObjects = "caribou",
    .saveInitialTime = 1, .saveInterval = 1
  ),
  randomLandscapes = list(.plotInitialTime = NA, nx = 20, ny = 20))

modules <- list("randomLandscapes", "caribouMovement")
paths <- list(
  modulePath = system.file("sampleModules", package = "SpaDES.core"),
  outputPath = savePath
)
mySim <- simInit(times = times, params = parameters, modules = modules,
                 paths = paths)

# The caribou module has a saveFiles(sim) call, so it will save caribou
spades(mySim)
dir(outputPath)

# remove the files
file.remove(dir(savePath, full.names = TRUE))

}
}
\author{
Eliot McIntire

Alex Chubaty
}
