% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{spadesOptions}
\alias{spadesOptions}
\title{\code{SpaDES.core} options}
\usage{
spadesOptions()
}
\value{
named list of the \emph{default} package options.
}
\description{
These provide top-level, powerful settings for a comprehensive SpaDES workflow.
To see defaults, run \code{spadesOptions()}.
See Details below.
}
\details{
Below are options that can be set with \code{options("spades.xxx" = newValue)},
where \code{xxx} is one of the values below, and \code{newValue} is a new value to
give the option. Sometimes these options can be placed in the user's \code{.Rprofile}
file so they persist between sessions.

The following options are likely of interest to most users
\tabular{lcl}{
\emph{OPTION} \tab \emph{DEFAULT VALUE} \tab \emph{DESCRIPTION} \cr
\code{spades.allowInitDuringSimInit} \tab \code{FALSE}
\tab New feature as of \verb{SpaDES.core > 1.1.1.9001}; If set to \code{TRUE},
\code{simInit} will evaluate the dependencies in the metadata objects and determine whether
there are modules whose \code{init} events can be run safely prior to
the \code{.inputObjects} of other modules, i.e., if a module's \code{expectsInput}
is not being supplied by any other module's \code{createsOutput}. \cr

\code{spades.browserOnError} \tab \code{FALSE} \tab If \code{TRUE}, the default, then any
error rerun the same event with \code{debugonce} called on it to allow editing
to be done. When that browser is continued (e.g., with 'c'), then it will save it
re-parse it into the \code{simList} and rerun the edited version.
This may allow a \code{spades()} call to be recovered on error,
though in many cases that may not be the correct behaviour.
For example, if the \code{simList} gets updated inside that event in an iterative
manner, then each run through the event will cause that iteration to occur.
When this option is \code{TRUE}, then the event will be run at least 3 times: the
first time makes the error, the second time has \code{debugonce} and the third time
is after the error is addressed. \code{TRUE} is likely somewhat slower. \cr

\code{reproducible.cachePath} \tab \code{getOption('reproducible.cachePath')}
\tab The default local directory in which to cache simulation outputs.
Default is a temporary directory (typically \verb{/tmp/RtmpXXX/SpaDES/cache}).\cr

\code{spades.debug} \tab \code{TRUE}
\tab  The default debugging value \code{debug} argument in \code{spades()} \cr

\code{spades.dotInputObjects} \tab \code{TRUE}
\tab  This is used in \code{simInit}; if set to \code{TRUE} then the \code{.inputObjects}
function will be run; if \code{FALSE}, then it will be skipped.\cr

\code{spades.DTthreads} \tab \code{1L}
\tab  The default number of \pkg{data.table} threads to use.
See also \code{?data.table::setDTthreads}. \cr

\code{spades.futureEvents} \tab \code{FALSE}
\tab  If set to \code{TRUE}, the event simulator will attempt to spawn events
whose outputs are not needed (by other events in the \code{simList}) into a future.
In some cases, this will speed up simulations, by running some events in parallel.
Still VERY experimental. Use cautiously. \cr

\code{spades.inputPath}
\tab Default is a temporary directory (typically \verb{/tmp/RtmpXXX/SpaDES/inputs})
\tab The default local directory in which to look for simulation inputs.  \cr

\code{spades.loadReqdPkgs}
\tab Default is \code{TRUE} meaning that any \code{reqdPkgs} will be loaded via \code{Require}
or \code{require}. If \code{FALSE}, no package loading will occur. This will mean that
modules must prefix every function call from a package with that package name
with double colon (::).  \cr

\code{spades.lowMemory} \tab \code{FALSE}
\tab If true, some functions will use more memory
efficient (but slower) algorithms. \cr

\code{spades.memoryUseInterval} \tab \code{FALSE}
\tab A numeric in seconds indicating how often sample the memory use. This will
be run in a separate "future" process so it can monitor the main process.
To access the resulting memory use table, use \code{memoryUse(sim)} after the simulation
has terminated. \cr

\code{spades.messagingNumCharsModule} \tab \code{21}
\tab The number of characters to use for the messaging preamble on each
line of the messaging during spades calls.\cr

\code{spades.moduleCodeChecks}
\tab \code{list(suppressParamUnused = FALSE, suppressUndefined = TRUE, suppressPartialMatchArgs = FALSE, suppressNoLocalFun = TRUE, skipWith = TRUE)}
\tab Should the various code checks be run
during \code{simInit}. These are passed to \code{codetools::checkUsage()}.
Default is given by the function, plus these: \cr

\code{spades.moduleDocument} \tab  \code{TRUE}
\tab  When a module is an R package e.g., via \code{convertToPackage},
it will, by default, rebuild documentation and reparse during \code{simInit}.
Since rebuilding documentation (from the \code{roxygen2} tags) can be time consuming,
a user may wish to prevent this from happening each \code{simInit} call. If so,
set this option to \code{FALSE} \cr

\code{spades.modulePath} \tab \code{file.path(tempdir(), "SpaDES", "modules")})
\tab The default local directory where modules and data will be downloaded and stored.
Default is a temporary directory  \cr

\code{spades.moduleRepo} \tab  \code{"PredictiveEcology/SpaDES-modules"}
\tab  The default GitHub repository to use when
downloading modules via \code{downloadModule} \cr

\code{spades.nCompleted} \tab \code{1000L} \tab The maximum number of completed events to
retain in the \code{completed} event queue. \cr

\code{spades.outputPath}
\tab \code{file.path(tempdir(), "SpaDES", "outputs")}
\tab The default local directory in which to save simulation outputs.\cr

\code{spades.plots}
\tab The value of this will passed to \code{.plots} within every module; it will thus
override all module parameter values for \code{.plots}. This can, e.g., be used
to turn off all plotting.
\tab The default is NULL, meaning accept the module-level parameter\cr

\code{spades.recoveryMode} \tab \code{1L} \tab
If this is a numeric greater than 0 or TRUE, then the
discrete event simulator will take a snapshot of the objects in the \code{simList}
that might change (based on metadata \code{outputObjects} for that module), prior to
initiating every event. This will allow the
user to be able to recover in case of an error or manual interruption (e.g., \code{Esc}).
If this is numeric, a copy of that number of "most
recent events" will be maintained so that the user can recover and restart
more than one event in the past, i.e., redo some of the "completed" events.
Default is \code{TRUE}, i.e., it will keep the state of the \code{simList}
at the start of the current event. This can be recovered with \code{restartSpades}
and the differences can be seen in a hidden object in the stashed \code{simList}.
There is a message which describes how to find that. \cr

\code{spades.saveFileExtensions} \tab \code{NULL} \tab
a \code{data.frame} with 3 columns, \code{exts}, \code{fun}, and \code{package} indicating which
file extension, and which function from which package will be used when
using the \code{outputs} mechanism for saving files during a \code{spades} call. e.g.,
\verb{options(spades.saveFileExtensions = data.frame(exts = "shp", fun = "st_write", package = "sf")}.
Then specify e.g.,
\code{simInit(outputs = data.frame(objectName = "caribou", fun = "st_write", package = "sf"))}
\cr

\code{spades.scratchPath} \tab \code{file.path(tempdir(), "SpaDES", "scratch")})
\tab The default local directory where transient files from modules and data will written.
This includes temporary \code{raster} and \code{terra} files, as well as SpaDES recovery mode files.
Default is a temporary directory. \cr

\code{spades.sessionInfo} \tab \code{TRUE})
\tab Assigns the \code{\link[utils:sessionInfo]{utils::sessionInfo()}} to the \code{simList} during \code{simInit} with
the name \code{sim$._sessionInfo}. This takes about 75 milliseconds, which may be
undesirable for some situations where speed is critical. If \code{FALSE}, then
this is not assigned to the \code{simList}.\cr

\code{spades.switchPkgNamespaces} \tab \code{FALSE} to keep computational
overhead down. \tab Should the search path be modified
to ensure a module's required packages are listed first?
If \code{TRUE}, there should be no name conflicts among package objects,
but it is much slower, especially if the events are themselves fast. \cr

\code{spades.testMemoryLeaks} \tab \code{TRUE}.
\tab  There is a very easy way to create a memory leak with R and SpaDES,
by adding formulas or functions to \verb{sim$} when the enclosing environment
of the formula or function contained a large object, most relevant here is
the \code{sim} object. SpaDES.core now tests for likely culprits for this
and suggests alternatives with a warning \cr

\code{spades.tolerance} \tab \code{.Machine$double.eps^0.5}.
\tab  The default tolerance value used for floating
point number comparisons. \cr

\code{spades.useragent} \tab \code{"https://github.com/PredictiveEcology/SpaDES"}.
\tab : The default user agent to use for downloading modules from GitHub. \cr

\code{spades.useRequire} \tab \code{!tolower(Sys.getenv("SPADES_USE_REQUIRE")) \%in\% "false"}
\tab : The default for that environment variable is unset, so this returns
\code{TRUE}. If this is \code{TRUE}, then during the \code{simInit} call, when packages are
identified as being required, these will be installed if missing, only if
\code{spades.useRequire} option is \code{TRUE}, otherwise, \code{simInit} will fail because
packages are not available.\cr

}
}
