% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerical-comparisons.R
\name{inRange}
\alias{inRange}
\title{Test whether a number lies within range \code{[a,b]}}
\usage{
inRange(x, a = 0, b = 1)
}
\arguments{
\item{x}{values to be tested}

\item{a}{lower bound (default 0)}

\item{b}{upper bound (default 1)}
}
\value{
Logical vectors. \code{NA} values in \code{x} are retained.
}
\description{
Default values of \code{a=0; b=1} allow for quick test if
\code{x} is a probability.
}
\examples{
set.seed(100)
x <- stats::rnorm(4) # -0.50219235  0.13153117 -0.07891709  0.88678481
inRange(x, 0, 1)

}
\author{
Alex Chubaty
}
