% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood.R
\name{wrap}
\alias{wrap}
\title{Wrap coordinates or pixels in a torus-like fashion}
\usage{
wrap(X, bounds, withHeading = FALSE)
}
\arguments{
\item{X}{\code{SpatVector}, \code{sf}, or matrix of coordinates.}

\item{bounds}{Either a \verb{SpatRaster*}, \code{Extent}, or \code{bbox} object defining bounds to wrap around.}

\item{withHeading}{logical. If \code{TRUE}, the previous points must be wrapped
also so that the subsequent heading calculation will work.
Default \code{FALSE}. See details.}
}
\value{
Object of the same class as \code{X}, but with coordinates updated to reflect the wrapping.
}
\description{
Generally useful for model development purposes. Primarily used internally
in e.g., \code{crw} if \code{torus = TRUE}.
}
\details{
If \code{withHeading} used, then \code{X} must be an \code{sf} or \code{SpatVector} object
that contains two columns, \code{x1} and \code{y1}, with the immediately
previous agent locations.
}
\examples{
origDTThreads <- data.table::setDTthreads(2L)
origNcpus <- options(Ncpus = 2L)

xrange <- yrange <- c(-50, 50)
hab <- terra::rast(terra::ext(c(xrange, yrange)))
hab[] <- 0

# initialize agents
N <- 10

# previous points
x1 <- y1 <- rep(0, N)
# initial points
starts <- cbind(x = stats::runif(N, xrange[1], xrange[2]),
                y = stats::runif(N, yrange[1], yrange[2]))

# create the agent object # the x1 and y1 are needed for "previous location"
agent <- terra::vect(data.frame(x1, y1, starts), geom = c("x", "y"))

ln <- rlnorm(N, 1, 0.02) # log normal step length
sd <- 30 # could be specified globally in params

if (interactive()) {
  # clearPlot()
  terra::plot(hab, col = "white")
}

for (i in 1:10) {
  agent <- crw(agent = agent, extent = terra::ext(hab), stepLength = ln,
               stddev = sd, lonlat = FALSE, torus = FALSE) # don't wrap
  if (interactive()) terra::plot(agent[, 1], add = TRUE, col = 1:10)
}
terra::crds(agent) # many are "off" the map, i.e., beyond the extent of hab
agent <- SpaDES.tools::wrap(agent, bounds = terra::ext(hab))
terra::plot(agent, add = TRUE, col = 1:10) # now inside the extent of hab

# clean up
data.table::setDTthreads(origDTThreads)
options(Ncpus = origNcpus)

}
\author{
Eliot McIntire
}
