% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-other.R
\docType{methods}
\name{clearPlot}
\alias{clearPlot}
\alias{clearPlot,missing,logical-method}
\alias{clearPlot,missing,missing-method}
\alias{clearPlot,numeric,logical-method}
\alias{clearPlot,numeric,missing-method}
\title{Clear plotting device}
\usage{
clearPlot(dev = dev.cur(), removeData = TRUE)

\S4method{clearPlot}{numeric,logical}(dev = dev.cur(), removeData = TRUE)

\S4method{clearPlot}{numeric,missing}(dev)

\S4method{clearPlot}{missing,logical}(removeData)

\S4method{clearPlot}{missing,missing}(dev = dev.cur(), removeData = TRUE)
}
\arguments{
\item{dev}{Numeric. Device number to clear.}

\item{removeData}{Logical indicating whether any data that was stored in the
\code{.spadesEnv} should also be removed; i.e., not just the plot window wiped.}
}
\description{
Under some conditions, a device and its metadata need to be cleared manually.
This can be done with either the \code{new = TRUE} argument within the call to
\code{Plot}.
Sometimes, the metadata of a previous plot will prevent correct plotting of
a new \code{Plot} call.
Use \code{clearPlot} to clear the device and all the associated metadata
manually.
}
\author{
Eliot McIntire
}

