% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-repository.R
\docType{methods}
\name{checksums}
\alias{checksums}
\alias{checksums,character,character,logical-method}
\alias{checksums,character,character,missing-method}
\title{Calculate checksums for a module's data files}
\usage{
checksums(module, path, write)

\S4method{checksums}{character,character,logical}(module, path, write)

\S4method{checksums}{character,character,missing}(module, path)
}
\arguments{
\item{module}{Character string giving the name of the module.}

\item{path}{Character string giving the path to the module directory.}

\item{write}{Logical indicating whether to overwrite \code{CHECKSUMS.txt}.
Default is \code{FALSE}, as users should not change this file.
Module developers should write this file prior to distributing
their module code, and update accordingly when the data change.}
}
\value{
A data.frame with columns: result, expectedFile, actualFile, and checksum.
}
\description{
Verify (and optionally write) checksums for data files in a module's
\code{data/} subdirectory. The file \code{data/CHECKSUMS.txt} contains the
expected checksums for each data file.
Checksums are computed using \code{SpaDES:::digest}, which is simply a
wrapper around \code{digest::digest}.
}
\details{
Modules may require data that for various reasons cannot be distributed with
the module source code. In these cases, the module developer should ensure
that the module downloads and extracts the data required. It is useful to not
only check that the data files exist locally but that their checksums match
those expected. See also \code{\link{downloadData}}.
}
\author{
Alex Chubaty
}

