% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFrame.R
\docType{methods}
\name{histogram}
\alias{histogram}
\alias{histogram,SparkDataFrame,characterOrColumn-method}
\title{Compute histogram statistics for given column}
\usage{
\S4method{histogram}{SparkDataFrame,characterOrColumn}(df, col, nbins = 10)
}
\arguments{
\item{df}{the SparkDataFrame containing the Column to build the histogram from.}

\item{col}{the column as Character string or a Column to build the histogram from.}

\item{nbins}{the number of bins (optional). Default value is 10.}
}
\value{
a data.frame with the histogram statistics, i.e., counts and centroids.
}
\description{
This function computes a histogram for a given SparkR Column.
}
\note{
histogram since 2.0.0
}
\examples{
\dontrun{

# Create a SparkDataFrame from the Iris dataset
irisDF <- createDataFrame(iris)

# Compute histogram statistics
histStats <- histogram(irisDF, irisDF$Sepal_Length, nbins = 12)

# Once SparkR has computed the histogram statistics, the histogram can be
# rendered using the ggplot2 library:

require(ggplot2)
plot <- ggplot(histStats, aes(x = centroids, y = counts)) +
        geom_bar(stat = "identity") +
        xlab("Sepal_Length") + ylab("Frequency")
}
}
\seealso{
Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{arrange}},
  \code{\link{as.data.frame}}, \code{\link{attach}},
  \code{\link{cache}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{dapplyCollect}},
  \code{\link{dapply}}, \code{\link{describe}},
  \code{\link{dim}}, \code{\link{distinct}},
  \code{\link{dropDuplicates}}, \code{\link{dropna}},
  \code{\link{drop}}, \code{\link{dtypes}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{insertInto}},
  \code{\link{intersect}}, \code{\link{isLocal}},
  \code{\link{join}}, \code{\link{limit}},
  \code{\link{merge}}, \code{\link{mutate}},
  \code{\link{ncol}}, \code{\link{nrow}},
  \code{\link{persist}}, \code{\link{printSchema}},
  \code{\link{randomSplit}}, \code{\link{rbind}},
  \code{\link{registerTempTable}}, \code{\link{rename}},
  \code{\link{repartition}}, \code{\link{sample}},
  \code{\link{saveAsTable}}, \code{\link{schema}},
  \code{\link{selectExpr}}, \code{\link{select}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{take}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{with}},
  \code{\link{write.df}}, \code{\link{write.jdbc}},
  \code{\link{write.json}}, \code{\link{write.orc}},
  \code{\link{write.parquet}}, \code{\link{write.text}}
}
