% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_regression.R
\docType{methods}
\name{spark.isoreg}
\alias{spark.isoreg}
\alias{spark.isoreg}
\alias{spark.isoreg,SparkDataFrame,formula-method}
\alias{summary,IsotonicRegressionModel-method}
\alias{predict,IsotonicRegressionModel-method}
\alias{predict,IsotonicRegressionModel,SparkDataFrame-method}
\alias{write.ml,IsotonicRegressionModel,character-method}
\title{Isotonic Regression Model}
\usage{
spark.isoreg(data, formula, ...)

\S4method{spark.isoreg}{SparkDataFrame,formula}(data, formula,
  isotonic = TRUE, featureIndex = 0, weightCol = NULL)

\S4method{summary}{IsotonicRegressionModel}(object)

\S4method{predict}{IsotonicRegressionModel}(object, newData)

\S4method{write.ml}{IsotonicRegressionModel,character}(object, path,
  overwrite = FALSE)
}
\arguments{
\item{data}{SparkDataFrame for training.}

\item{formula}{A symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{isotonic}{Whether the output sequence should be isotonic/increasing (TRUE) or
antitonic/decreasing (FALSE).}

\item{featureIndex}{The index of the feature if \code{featuresCol} is a vector column
(default: 0), no effect otherwise.}

\item{weightCol}{The weight column name.}

\item{object}{a fitted IsotonicRegressionModel.}

\item{newData}{SparkDataFrame for testing.}

\item{path}{The directory where the model is saved.}

\item{overwrite}{Overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.isoreg} returns a fitted Isotonic Regression model.

\code{summary} returns summary information of the fitted model, which is a list.
        The list includes model's \code{boundaries} (boundaries in increasing order)
        and \code{predictions} (predictions associated with the boundaries at the same index).

\code{predict} returns a SparkDataFrame containing predicted values.
}
\description{
Fits an Isotonic Regression model against a SparkDataFrame, similarly to R's isoreg().
Users can print, make predictions on the produced model and save the model to the input path.
}
\note{
spark.isoreg since 2.1.0

summary(IsotonicRegressionModel) since 2.1.0

predict(IsotonicRegressionModel) since 2.1.0

write.ml(IsotonicRegression, character) since 2.1.0
}
\examples{
\dontrun{
sparkR.session()
data <- list(list(7.0, 0.0), list(5.0, 1.0), list(3.0, 2.0),
        list(5.0, 3.0), list(1.0, 4.0))
df <- createDataFrame(data, c("label", "feature"))
model <- spark.isoreg(df, label ~ feature, isotonic = FALSE)
# return model boundaries and prediction as lists
result <- summary(model, df)
# prediction based on fitted model
predict_data <- list(list(-2.0), list(-1.0), list(0.5),
                list(0.75), list(1.0), list(2.0), list(9.0))
predict_df <- createDataFrame(predict_data, c("feature"))
# get prediction column
predict_result <- collect(select(predict(model, predict_df), "prediction"))

# save fitted model to input path
path <- "path/to/model"
write.ml(model, path)

# can also read back the saved model and print
savedModel <- read.ml(path)
summary(savedModel)
}
}
