% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/WindowSpec.R
\name{rangeBetween}
\alias{rangeBetween}
\alias{rangeBetween,WindowSpec,numeric,numeric-method}
\title{rangeBetween}
\usage{
rangeBetween(x, start, end)

\S4method{rangeBetween}{WindowSpec,numeric,numeric}(x, start, end)
}
\arguments{
\item{x}{a WindowSpec}

\item{start}{boundary start, inclusive.
The frame is unbounded if this is the minimum long value.}

\item{end}{boundary end, inclusive.
The frame is unbounded if this is the maximum long value.}
}
\value{
a WindowSpec
}
\description{
Defines the frame boundaries, from \code{start} (inclusive) to \code{end} (inclusive).
}
\details{
Both \code{start} and \code{end} are relative from the current row. For example, "0" means
"current row", while "-1" means one off before the current row, and "5" means the five off
after the current row.
}
\note{
rangeBetween since 2.0.0
}
\examples{
\dontrun{
  rangeBetween(ws, 0, 3)
}
}
\seealso{
Other windowspec_method: 
\code{\link{orderBy}()},
\code{\link{partitionBy}()},
\code{\link{rowsBetween}()}
}
\concept{windowspec_method}
