% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ShotSeasonGraph}
\alias{ShotSeasonGraph}
\title{plot the shot chart of a whole NBA Season}
\usage{
ShotSeasonGraph(Seasondata, quant = 0.4, type = "PPS")
}
\arguments{
\item{Seasondata}{The information of shots, it can be downloaded with function
read_season}

\item{quant}{A number between 0 and 1, it determines quantile of shots used
to plot the shot chart, (default is 0.4)}

\item{type}{A character to specify if the shot chart is based on Points per
Shot ("PPS") or percentage ("PCT")}
}
\value{
a ggplot object plotting the shot chart of a given NBA season
}
\description{
This function takes an NBA season object and makes a shot chart of all the
shots takes through that regular season.
You can choose to either plot the results based on Points per Shot or on
Shooting Percentage
}
\examples{
data("season2017")
ShotSeasonGraph(season2017, quant = 0.4)
ShotSeasonGraph(season2017, quant = 0.4, type = "PCT")
}
\seealso{
\code{\link[SpatialBall]{DefShotSeasonGraphTeam}}

\code{\link[SpatialBall]{OffShotSeasonGraphTeam}}
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
