% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ShotSeasonGraphPlayer}
\alias{ShotSeasonGraphPlayer}
\title{Generates a shot chart for a given player}
\usage{
ShotSeasonGraphPlayer(Seasondata, player, quant = 0.4, type = "PPS")
}
\arguments{
\item{Seasondata}{a data frame with the details of the season}

\item{player}{the name of the player that you want to make a graph of}

\item{quant}{the quantile of shots to be graphed, defaults to 0.4}

\item{type}{either "PPS" for points per shot or "PCT" for percentage}
}
\value{
a shot chart graph
}
\description{
Creates a shot chart for a player on a given season
}
\examples{
data("season2017")
#Examples with several players
ShotSeasonGraphPlayer(season2017, player = "Stephen Curry")
ShotSeasonGraphPlayer(season2017, player = "DeMar DeRozan")

 #Examples with percentage instead of points per shot
ShotSeasonGraphPlayer(season2017, player = "Stephen Curry", type = "PCT")
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
