# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Heuristic Product Within Distance (Spatially Balanced Sampling).
#'
#' The function \code{hpwd} provides a fast selection of spatially balanced samples: it is a heuristic and a fast implemention of the algorithm \code{\link{pwd}}.
#' It generates samples approximately with the same probabilities of the \code{\link{pwd}} but with a significantly smaller number of steps.
#' In fact, this algorithm randomly selects a sample of size \eqn{n} exactly with \eqn{n} steps, updating at each step the selection probability of not-selected units, depending on their distance from the units, that were already selected in the previous steps.
#' To have constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, the distance matrix has to be standardized with function \code{\link{stprod}}.
#' Note that there is a parameter \eqn{\beta} which regulates the spread of the sample: The higher \eqn{\beta} is, the more the sample is going to be spread.
#' This parameter is regulated by the exponent of the distance matrix (D^1 -> \eqn{\beta = 1}, D^10 -> \eqn{\beta = 10}).
#'
#' @param dis A distance matrix NxN that specifies how far are all the pairs of units in the population.
#' @param nsamp Sample size.
#' @param nrepl Number of samples to draw (default = 1).
#' @return Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#'
#' \insertRef{fast_selection}{Spbsampling}
#' @examples
#' # Example 1
#' # Draw 50 samples of dimension 10 without constant probabilities and beta = 1
#' dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
#' samples <- hpwd(dis, 10, 50) # drawn samples
#' \donttest{
#' # Example 2
#' # Draw 100 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 1
#' # with N = population size
#' dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
#' vec <- rep(1, nrow(dis)) # vector of constraints
#' stand_dist <- stprod(dis, vec, 1e-15, 1000) # standardized matrix
#' samples <- hpwd(stand_dist, 15, 100) # drawn samples
#'
#' # Example 3
#' # Draw 100 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 10
#' # with N = population size
#' dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
#' dis <- dis^10 # setting beta = 10
#' vec <- rep(1, nrow(dis)) # vector of constraints
#' stand_dist <- stprod(dis, vec, 1e-15, 1000) # standardized matrix
#' samples <- hpwd(stand_dist, 15, 100) # drawn samples
#' }
#' @export
hpwd <- function(dis, nsamp, nrepl = 1L) {
    .Call(`_Spbsampling_hpwd`, dis, nsamp, nrepl)
}

#' Product Within Distance (Spatially Balanced Sampling).
#'
#' This is an implemention of a spatially balanced design, with a probability function proportional to the within sample distance, using the product of distance as an index of the within sample distance (Product Within Distance, \code{pwd} in short).
#' To have constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, the distance matrix has to be standardized with function \code{\link{stprod}}.
#' Note that there is a parameter \eqn{\beta} which regulates the spread of the sample: The higher \eqn{\beta} is, the more the sample is going to be spread.
#' This parameter is regulated by the exponent of the distance matrix (D^1 -> \eqn{\beta = 1}, D^10 -> \eqn{\beta = 10}).
#'
#' @param dis A distance matrix NxN that specifies how far are all the pairs of units in the population.
#' @param nsamp Sample size.
#' @param nrepl Number of samples to draw (default = 1).
#' @param niter Number of iterations for the algorithm. More iterations are better but require more time. Usually 10 is very efficient (default = 10).
#' @return Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#' @examples
#' # Example 1
#' # Draw 20 samples of dimension 15 without constant probabilities and with beta = 1
#' dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
#' nsamp <- 15  # sample size
#' nrepl <- 20  # number of samples to draw
#' niter <- 10  # number of iterations in the algorithm
#' samples <- pwd(dis, niter, nsamp, nrepl)  # drawn samples
#' \donttest{
#' # Example 2
#' # Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N
#' # with N = population size
#' dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
#' nsamp <- 15  # sample size
#' nrepl <- 20  # number of samples to draw
#' niter <- 10  # number of iterations in the algorithm
#' vec <- rep(0, nrow(dis)) # vector of constraints
#' stand_dist <- stprod(dis, vec ,1e-15 ,1000) # standardized matrix
#' samples <- pwd(stand_dist, niter, nsamp, nrepl)  # drawn samples
#'
#' # Example 3
#' # Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 10
#' # with N = population size
#' dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
#' dis <- dis^10 # setting beta = 10
#' nsamp <- 15  # sample size
#' nrepl <- 20  # number of samples to draw
#' niter <- 10  # number of iterations in the algorithm
#' vec <- rep(0, nrow(dis)) # vector of constraints
#' stand_dist <- stprod(dis, vec, 1e-15, 1000) # standardized matrix
#' samples <- pwd(stand_dist, niter, nsamp, nrepl)  # drawn samples
#' }
#' @export
pwd <- function(dis, nsamp, nrepl = 1L, niter = 10L) {
    .Call(`_Spbsampling_pwd`, dis, nsamp, nrepl, niter)
}

#' Spatial Balance Index.
#'
#' \code{sbi} computes the Spatial Balance Index (SBI), which is a measure of balance of a sample. The lower it is, the better the balance.
#'
#' The SBI is based on Voronoi polygons. Given a sample s, each unit \eqn{i} in the sample has its own Voronoi polygon, which is
#' composed by all population units closer to \eqn{i} than to any other sample unit \eqn{j}. Then, per each Voronoi polygon, define \eqn{v_{i}}
#' as the sum of the inclusion probabilities of all units in the \eqn{i}-th Voronoi polygon. Finally, the variance of \eqn{v_{i}} is the SBI.
#'
#' @param dis A distance matrix NxN that specifies how far are all the pairs of units in the population.
#' @param pi A vector of first order inclusion probabilities of the units of the population.
#' @param s A vector of labels of the sample.
#' @return Return the Spatial Balance Index.
#' @references
#' \insertRef{StevensDonL2004SBSo}{Spbsampling}
#' @examples
#' \dontshow{
#' d <- matrix(runif(200), 100, 2)
#' dis <- as.matrix(dist(d))
#' pi <- rep(10 / 100, 100)
#' sample <- sample(1:100,10)
#' sbi(dis, pi, sample)
#' }
#' \donttest{
#' dis <- as.matrix(dist(cbind(simul1$x, simul1$y))) # distance matrix
#' vec <- rep(0, nrow(dis)) # vector of constraints
#' stand_dist <- stprod(dis, vec) # standardized matrix
#' nsamp <- 100 # sample size
#' pi <- rep(100 / nrow(dis), nrow(dis)) # vector of probabilities inclusion
#' sample <- pwd(stand_dist, 100) # sample
#' sbi(dis, pi, sample[, 2])
#' }
#' @importFrom stats var
#' @export
sbi <- function(dis, pi, s) {
    .Call(`_Spbsampling_sbi`, dis, pi, s)
}

#' Standardize a symmetric matrix (distances) to fixed row (column) products.
#'
#' \code{stprod} standardizes the distance matrix to fixed rows and columns products to use \code{\link{pwd}}.
#' The function iteratively constrains a logarithmic transformed matrix to know products, and in order to keep the symmetry of the matrix, at each iteration performs an average with its transpose.
#' When the known products are all equal to a constant (e.g. 1), this method provides a simple and accurate way to scale a distance matrix to a doubly stochastic matrix. The new matrix will not be affected by problems arising from units with different inclusion probabilities, due to not required features of the spatial distribution of the population, such as edge effects and isolated points.
#'
#' @param mat A distance matrix size NxN.
#' @param vec A vector of row (column) constraints.
#' @param differ A scalar with the maximum accepted difference with the constraint (default = 1e-15).
#' @param niter An integer with the maximum number of iterations (default = 1000).
#' @return Return a distance matrix constrained size NxN.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#' @examples
#' \dontshow{
#' d <- matrix(runif(200), 100, 2)
#' dis <- as.matrix(dist(d))
#' vec <- rep(0, nrow(dis))
#' stand_dist <- stprod(dis, vec, 1e-15, 1000)
#' }
#' \donttest{
#' dis <- as.matrix(dist(cbind(simul1$x, simul1$y))) # distance matrix
#' con <- rep(0, nrow(dis)) # vector of constraints
#' stand_dist <- stprod(dis, con) # standardized matrix
#' }
#' @export
stprod <- function(mat, vec, differ = 1e-15, niter = 1000L) {
    .Call(`_Spbsampling_stprod`, mat, vec, differ, niter)
}

#' Standardize a symmetric matrix (distances) to fixed row (column) totals.
#'
#' \code{stsum} standardizes the distance matrix to fixed rows and columns products for using \code{\link{swd}}.
#' The function iteratively constrains the rows sums of the matrix to know totals, and in order to keep the symmetry of the matrix, at each iteration performs an average with its transpose.
#' When the known totals are all equal to a constant (e.g. 1), this method provides a simple and accurate way to scale a distance matrix to a doubly stochastic matrix. The new matrix will not be affected by problems arising from units with different inclusion probabilities, due to not required features of the spatial distribution of the population, such as edge effects and isolated points.
#'
#' @param  mat A distance matrix size NxN.
#' @param  vec A vector of row (column) constraints.
#' @param differ A scalar with the maximum accepted difference with the constraint (default = 1e-15).
#' @param niter An integer with the maximum number of iterations (default = 1000).
#' @return Return a distance matrix constrained size NxN.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#' @examples
#' dis <- as.matrix(dist(cbind(simul2$x, simul2$y))) # distance matrix
#' con <- rep(1, nrow(dis)) # vector of constraints
#' stand_dist <- stsum(dis, con) # standardized matrix
#' @export
stsum <- function(mat, vec, differ = 1e-15, niter = 1000L) {
    .Call(`_Spbsampling_stsum`, mat, vec, differ, niter)
}

#' Sum Within Distance (Spatially Balanced Sampling).
#'
#' This is an implemention of a spatially balanced design, with a probability function proportional to the within sample distance, using the sum of distance as an index of the within sample distance (Sum Within Distance, \code{swd} in short).
#' To have a constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, standardize the distance matrix with function \code{\link{stsum}}.
#'
#' @param dis A distance matrix NxN that specifies how far are all the pairs of units in the population.
#' @param nsamp Sample size.
#' @param bexp Parameter \eqn{\beta} for the algorithm. The higher \eqn{\beta} is, the more the sample is going to be spread.
#' @param nrepl Number of samples to draw (default = 1).
#' @param niter Number of iterations for the algorithm. More iterations are better but require more time. Usually 10 is very efficient (default = 10).
#' @return Return a matrix 2 x \code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
#' @references
#' \insertRef{BIMJ:BIMJ1785}{Spbsampling}
#' @examples
#' # Example 1
#' # Draw 20 samples of dimension 15 without constant probabilities and beta = 1
#' dis <- as.matrix(dist(cbind(income_emilia$x_coord, income_emilia$y_coord))) # distance matrix
#' nsamp <- 15  # sample size
#' nrepl <- 20  # number of samples to draw
#' niter <- 10  # number of iterations in the algorithm
#' bexp <- 10   # parameter beta
#' samples <- swd(dis, niter, nsamp, nrepl, bexp)  # drawn samples
#' \donttest{
#' # Example 2
#' # Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 10
#' # with N = population size
#' dis <- as.matrix(dist(cbind(income_emilia$x_coord,income_emilia$y_coord))) # distance matrix
#' nsamp <- 15  # sample size
#' nrepl <- 20  # numbers of samples to drawn
#' niter <- 10  # numbers of iterations in the algorithm
#' bexp <- 10  # parameter beta
#' vec <- rep(1, nrow(dis)) # vector of constraints
#' stand_dist <- stsum(dis, vec, 1e-15, 1000) # standardized matrix
#' samples <- swd(stand_dist, niter, nsamp, nrepl, bexp)  # drawn samples
#' }
#' @export
swd <- function(dis, nsamp, bexp, nrepl = 1L, niter = 10L) {
    .Call(`_Spbsampling_swd`, dis, nsamp, bexp, nrepl, niter)
}

