% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScoreDiff.R
\name{ScoreDiff}
\alias{ScoreDiff}
\title{Calculate average score difference and assess uncertainty}
\usage{
ScoreDiff(scores, scores.ref, N.eff = NA, conf.level = 0.95,
  handle.na = "na.fail")
}
\arguments{
\item{scores}{vector of verification scores}

\item{scores.ref}{vector of verification scores of the reference forecast, must be of the same length as `scores`}

\item{N.eff}{user-defined effective sample size to be used in hypothesis test and for confidence bounds; if NA, the length of `scores` is used; default: NA}

\item{conf.level}{confidence level for the confidence interval; default = 0.95}

\item{handle.na}{how should missing values in scores vectors be handled; possible values are 'na.fail' and 'use.pairwise.complete'; default: 'na.fail'}
}
\value{
vector with mean score difference, estimated standard error of the mean, one-sided p-value of the Diebold-Mariano test, and the user-specified confidence interval
}
\description{
Calculate average score difference and assess uncertainty
}
\examples{
data(eurotempforecast)
ScoreDiff(EnsCrps(ens, obs), EnsCrps(ens[, 1:2], obs))
}
\references{
Diebold, Mariano (1995): Comparing Predictive Accuracy. Journal of Business & Economic Statistics. http://dx.doi.org/10.2307/1392185
}
\seealso{
SkillScore
}

